/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.management.data;

public class ThreadCountPoint {
    private int threadCount;
    private int daemonThreadCount;

    ThreadCountPoint(int threadCount, int daemonThreadCount) {
        this.threadCount = threadCount;
        this.daemonThreadCount = daemonThreadCount;
    }

    public static ThreadCountPointBuilder builder() {
        return new ThreadCountPointBuilder();
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getDaemonThreadCount() {
        return this.daemonThreadCount;
    }

    public static class ThreadCountPointBuilder {
        private int threadCount;
        private int daemonThreadCount;

        ThreadCountPointBuilder() {
        }

        public ThreadCountPointBuilder threadCount(int threadCount) {
            this.threadCount = threadCount;
            return this;
        }

        public ThreadCountPointBuilder daemonThreadCount(int daemonThreadCount) {
            this.daemonThreadCount = daemonThreadCount;
            return this;
        }

        public ThreadCountPoint build() {
            return new ThreadCountPoint(this.threadCount, this.daemonThreadCount);
        }

        public String toString() {
            return "ThreadCountPoint.ThreadCountPointBuilder(threadCount=" + this.threadCount + ", daemonThreadCount=" + this.daemonThreadCount + ")";
        }
    }
}

