/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.codec;

import com.tvd12.ezyfox.codec.EzyAbstractToByteBufferSerializer;
import com.tvd12.ezyfox.codec.MsgPackArraySizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackBinSizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackDoubleSerializer;
import com.tvd12.ezyfox.codec.MsgPackFloatSerializer;
import com.tvd12.ezyfox.codec.MsgPackIntSerializer;
import com.tvd12.ezyfox.codec.MsgPackMapSizeSerializer;
import com.tvd12.ezyfox.codec.MsgPackStringSizeSerializer;
import com.tvd12.ezyfox.entity.EzyArray;
import com.tvd12.ezyfox.entity.EzyArrayList;
import com.tvd12.ezyfox.entity.EzyHashMap;
import com.tvd12.ezyfox.entity.EzyObject;
import com.tvd12.ezyfox.function.EzyParser;
import com.tvd12.ezyfox.io.EzyByteBuffers;
import com.tvd12.ezyfox.io.EzyCastToByte;
import com.tvd12.ezyfox.io.EzyDataConverter;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyBoolsIterator;
import com.tvd12.ezyfox.util.EzyDoublesIterator;
import com.tvd12.ezyfox.util.EzyFloatsIterator;
import com.tvd12.ezyfox.util.EzyIntsIterator;
import com.tvd12.ezyfox.util.EzyLongsIterator;
import com.tvd12.ezyfox.util.EzyShortsIterator;
import com.tvd12.ezyfox.util.EzyStringsIterator;
import com.tvd12.ezyfox.util.EzyWrapperIterator;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class MsgPackToByteBufferSerializer
extends EzyAbstractToByteBufferSerializer
implements EzyCastToByte {
    protected final MsgPackIntSerializer intSerializer = MsgPackIntSerializer.getInstance();
    protected final MsgPackFloatSerializer floatSerializer = MsgPackFloatSerializer.getInstance();
    protected final MsgPackDoubleSerializer doubleSerializer = MsgPackDoubleSerializer.getInstance();
    protected final MsgPackBinSizeSerializer binSizeSerializer = MsgPackBinSizeSerializer.getInstance();
    protected final MsgPackMapSizeSerializer mapSizeSerializer = MsgPackMapSizeSerializer.getInstance();
    protected final MsgPackArraySizeSerializer arraySizeSerializer = MsgPackArraySizeSerializer.getInstance();
    protected final MsgPackStringSizeSerializer stringSizeSerializer = MsgPackStringSizeSerializer.getInstance();

    protected void addParsers(Map<Class<?>, EzyParser<Object, ByteBuffer>> parsers) {
        parsers.put(Boolean.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseBoolean));
        parsers.put(Byte.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseByte));
        parsers.put(Character.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseChar));
        parsers.put(Double.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseDouble));
        parsers.put(Float.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseFloat));
        parsers.put(Integer.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseInt));
        parsers.put(Long.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseInt));
        parsers.put(Short.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseShort));
        parsers.put(String.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseString));
        parsers.put(boolean[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveBooleans));
        parsers.put(byte[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseBin));
        parsers.put(char[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveChars));
        parsers.put(double[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveDoubles));
        parsers.put(float[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveFloats));
        parsers.put(int[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveInts));
        parsers.put(long[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveLongs));
        parsers.put(short[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parsePrimitiveShorts));
        parsers.put(String[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseStrings));
        parsers.put(Byte[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperBytes));
        parsers.put(Boolean[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperBooleans));
        parsers.put(Character[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperChars));
        parsers.put(Double[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperDoubles));
        parsers.put(Float[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperFloats));
        parsers.put(Integer[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperInts));
        parsers.put(Long[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperLongs));
        parsers.put(Short[].class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseWrapperShorts));
        parsers.put(Map.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseMap));
        parsers.put(AbstractMap.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseMap));
        parsers.put(HashMap.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseMap));
        parsers.put(EzyObject.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseObject));
        parsers.put(EzyHashMap.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseObject));
        parsers.put(EzyArray.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseArray));
        parsers.put(EzyArrayList.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseArray));
        parsers.put(Collection.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(AbstractCollection.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(Set.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(AbstractSet.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(List.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(AbstractList.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(HashSet.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(ArrayList.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseCollection));
        parsers.put(BigInteger.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseValueToString));
        parsers.put(BigDecimal.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseBigDecimalToString));
        parsers.put(UUID.class, (EzyParser<Object, ByteBuffer>)((EzyParser)this::parseValueToString));
    }

    protected ByteBuffer parsePrimitiveBooleans(Object array) {
        return this.parseBooleans((boolean[])array);
    }

    protected ByteBuffer parseBooleans(boolean[] array) {
        return this.parseArray((Iterator)EzyBoolsIterator.wrap((boolean[])array), array.length);
    }

    protected ByteBuffer parsePrimitiveChars(Object array) {
        return this.parseChars((char[])array);
    }

    protected ByteBuffer parseChars(char[] array) {
        return this.parseBin(EzyDataConverter.charArrayToByteArray((char[])array));
    }

    protected ByteBuffer parsePrimitiveDoubles(Object array) {
        return this.parseDoubles((double[])array);
    }

    protected ByteBuffer parseDoubles(double[] array) {
        return this.parseArray((Iterator)EzyDoublesIterator.wrap((double[])array), array.length);
    }

    protected ByteBuffer parsePrimitiveFloats(Object array) {
        return this.parseFloats((float[])array);
    }

    protected ByteBuffer parseFloats(float[] array) {
        return this.parseArray((Iterator)EzyFloatsIterator.wrap((float[])array), array.length);
    }

    protected ByteBuffer parsePrimitiveInts(Object array) {
        return this.parseInts((int[])array);
    }

    protected ByteBuffer parseInts(int[] array) {
        return this.parseArray((Iterator)EzyIntsIterator.wrap((int[])array), array.length);
    }

    protected ByteBuffer parsePrimitiveLongs(Object array) {
        return this.parseLongs((long[])array);
    }

    protected ByteBuffer parseLongs(long[] array) {
        return this.parseArray((Iterator)EzyLongsIterator.wrap((long[])array), array.length);
    }

    protected ByteBuffer parsePrimitiveShorts(Object array) {
        return this.parseShorts((short[])array);
    }

    protected ByteBuffer parseShorts(short[] array) {
        return this.parseArray((Iterator)EzyShortsIterator.wrap((short[])array), array.length);
    }

    protected ByteBuffer parseStrings(Object array) {
        return this.parseStrings((String[])array);
    }

    protected ByteBuffer parseStrings(String[] array) {
        return this.parseArray((Iterator)EzyStringsIterator.wrap((String[])array), array.length);
    }

    protected ByteBuffer parseWrapperBooleans(Object array) {
        return this.parseBooleans((Boolean[])array);
    }

    protected ByteBuffer parseBooleans(Boolean[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseWrapperBytes(Object array) {
        return this.parseBytes((Byte[])array);
    }

    protected ByteBuffer parseBytes(Byte[] array) {
        return this.parseBin(EzyDataConverter.toPrimitiveByteArray((Byte[])array));
    }

    protected ByteBuffer parseWrapperChars(Object array) {
        return this.parseChars((Character[])array);
    }

    protected ByteBuffer parseChars(Character[] array) {
        return this.parseBin(EzyDataConverter.charWrapperArrayToPrimitiveByteArray((Character[])array));
    }

    protected ByteBuffer parseWrapperDoubles(Object array) {
        return this.parseDoubles((Double[])array);
    }

    protected ByteBuffer parseDoubles(Double[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseWrapperFloats(Object array) {
        return this.parseFloats((Float[])array);
    }

    protected ByteBuffer parseFloats(Float[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseWrapperInts(Object array) {
        return this.parseInts((Integer[])array);
    }

    protected ByteBuffer parseInts(Integer[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseWrapperLongs(Object array) {
        return this.parseLongs((Long[])array);
    }

    protected ByteBuffer parseLongs(Long[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseWrapperShorts(Object array) {
        return this.parseShorts((Short[])array);
    }

    protected ByteBuffer parseShorts(Short[] array) {
        return this.parseArray((Iterator)EzyWrapperIterator.wrap((Object[])array), array.length);
    }

    protected ByteBuffer parseBoolean(Object value) {
        return this.parseBoolean((Boolean)value);
    }

    protected ByteBuffer parseBoolean(Boolean value) {
        return value != false ? this.parseTrue() : this.parseFalse();
    }

    protected ByteBuffer parseFalse() {
        return ByteBuffer.wrap(new byte[]{this.cast(194)});
    }

    protected ByteBuffer parseTrue() {
        return ByteBuffer.wrap(new byte[]{this.cast(195)});
    }

    protected ByteBuffer parseByte(Object value) {
        return this.parseByte((Byte)value);
    }

    protected ByteBuffer parseByte(Byte value) {
        return this.parseInt(value.intValue());
    }

    protected ByteBuffer parseChar(Object value) {
        return this.parseChar((Character)value);
    }

    protected ByteBuffer parseChar(Character value) {
        return this.parseByte((byte)value.charValue());
    }

    protected ByteBuffer parseDouble(Object value) {
        return this.parseDouble((Double)value);
    }

    protected ByteBuffer parseDouble(Double value) {
        return ByteBuffer.wrap(this.doubleSerializer.serialize(value));
    }

    protected ByteBuffer parseFloat(Object value) {
        return this.parseFloat((Float)value);
    }

    protected ByteBuffer parseFloat(Float value) {
        return ByteBuffer.wrap(this.floatSerializer.serialize(value.floatValue()));
    }

    protected ByteBuffer parseInt(Object value) {
        return ByteBuffer.wrap(this.intSerializer.serialize(((Number)value).longValue()));
    }

    protected ByteBuffer parseShort(Object value) {
        return this.parseShort((Short)value);
    }

    protected ByteBuffer parseShort(Short value) {
        return this.parseInt(value.intValue());
    }

    protected ByteBuffer parseString(Object string) {
        return this.parseString((String)string);
    }

    protected ByteBuffer parseString(String string) {
        ByteBuffer[] buffers = new ByteBuffer[2];
        buffers[1] = ByteBuffer.wrap(EzyStrings.getUtfBytes((String)string));
        buffers[0] = ByteBuffer.wrap(this.parseStringSize(buffers[1].remaining()));
        return EzyByteBuffers.merge((ByteBuffer[])buffers);
    }

    protected ByteBuffer parseMap(Object map) {
        return this.parseMap((Map)map);
    }

    protected ByteBuffer parseMap(Map map) {
        return this.parseEntries(map.entrySet());
    }

    protected ByteBuffer parseObject(Object obj) {
        return this.parseEntries(((EzyObject)obj).entrySet());
    }

    protected ByteBuffer parseArray(Object array) {
        return this.parseArray((EzyArray)array);
    }

    protected ByteBuffer parseArray(EzyArray array) {
        return this.parseArray(array.iterator(), array.size());
    }

    protected ByteBuffer parseArray(Iterator iterator, int size) {
        int index = 1;
        ByteBuffer[] buffers = new ByteBuffer[size + 1];
        buffers[0] = ByteBuffer.wrap(this.parseArraySize(size));
        while (iterator.hasNext()) {
            buffers[index++] = this.write(iterator.next());
        }
        return EzyByteBuffers.merge((ByteBuffer[])buffers);
    }

    protected ByteBuffer parseCollection(Object coll) {
        return this.parseCollection((Collection)coll);
    }

    protected ByteBuffer parseCollection(Collection coll) {
        return this.parseIterable(coll, coll.size());
    }

    protected ByteBuffer parseNil() {
        return ByteBuffer.wrap(new byte[]{this.cast(192)});
    }

    protected ByteBuffer parseBin(Object bin) {
        return this.parseBin((byte[])bin);
    }

    protected ByteBuffer parseBin(byte[] bin) {
        ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.wrap(this.parseBinSize(bin.length)), ByteBuffer.wrap(bin)};
        return EzyByteBuffers.merge((ByteBuffer[])buffers);
    }

    protected byte[] parseBinSize(int size) {
        return this.binSizeSerializer.serialize(size);
    }

    protected byte[] parseStringSize(int size) {
        return this.stringSizeSerializer.serialize(size);
    }

    protected ByteBuffer parseIterable(Iterable iterable, int size) {
        return this.parseArray(iterable.iterator(), size);
    }

    protected byte[] parseArraySize(int size) {
        return this.arraySizeSerializer.serialize(size);
    }

    protected ByteBuffer parseEntries(Set<Map.Entry<Object, Object>> entries) {
        int index = 1;
        int size = entries.size();
        ByteBuffer[] buffers = new ByteBuffer[size * 2 + 1];
        buffers[0] = ByteBuffer.wrap(this.parseMapSize(size));
        for (Map.Entry<Object, Object> e : entries) {
            buffers[index++] = this.write(e.getKey());
            buffers[index++] = this.write(e.getValue());
        }
        return EzyByteBuffers.merge((ByteBuffer[])buffers);
    }

    protected byte[] parseMapSize(int size) {
        return this.mapSizeSerializer.serialize(size);
    }

    protected ByteBuffer parseBigDecimalToString(Object value) {
        return this.parseString(((BigDecimal)value).toPlainString());
    }

    protected ByteBuffer parseValueToString(Object value) {
        return this.parseString(value.toString());
    }
}

