/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;

public abstract class AdminDataAppender<V, D, P>
extends EzyLoggable {
    private final ObjectMapper objectMapper;
    private final AdminSettingService settingService;
    private final AtomicReference<P> lastPageToken = new AtomicReference();
    private final String pageTokenKey = this.getAppenderNamePrefix() + "_appender_page_token";

    public final void append() {
        try {
            if (this.isRunnable()) {
                this.doAppend();
            }
        }
        catch (Exception e) {
            this.logger.warn("append data error", (Throwable)e);
        }
    }

    protected boolean isRunnable() {
        return this.settingService.isMasterServer();
    }

    protected void doAppend() {
        List<V> valueList;
        P pageToken = this.lastPageToken.get();
        if (pageToken == null) {
            pageToken = this.loadLastPageToken();
            this.lastPageToken.set(pageToken);
        }
        if ((valueList = this.getValueList(pageToken)).isEmpty()) {
            return;
        }
        List<V> filteredValueList = this.filterValueList(valueList);
        List<D> dataRecords = this.toDataRecords(filteredValueList);
        this.addDataRecords(dataRecords);
        P newPageToken = this.extractNewLastPageToken(valueList, pageToken);
        this.lastPageToken.set(newPageToken);
        String pageTokenString = this.serializePageToken(newPageToken);
        if (EzyStrings.isNotBlank((String)pageTokenString)) {
            this.settingService.setTextValue(this.pageTokenKey, pageTokenString);
        }
    }

    protected abstract List<V> getValueList(P var1);

    protected List<V> filterValueList(List<V> valueList) {
        return valueList;
    }

    protected D toDataRecord(V value) {
        return null;
    }

    protected List<D> toDataRecords(List<V> valueList) {
        return valueList.stream().flatMap(v -> this.toDataRecords(v).stream()).collect(Collectors.toList());
    }

    protected Collection<D> toDataRecords(V value) {
        D record = this.toDataRecord(value);
        return record == null ? Collections.emptyList() : Collections.singleton(record);
    }

    protected void addDataRecords(List<D> dataRecords) {
        this.dataRecordsToStream(dataRecords).forEach(this::addDataRecord);
    }

    protected Stream<D> dataRecordsToStream(List<D> dataRecords) {
        return dataRecords.stream();
    }

    protected void addDataRecord(D dataRecord) {
    }

    protected abstract P extractNewLastPageToken(List<V> var1, P var2);

    protected String serializePageToken(P pageToken) {
        try {
            return this.objectMapper.writeValueAsString(pageToken);
        }
        catch (Exception e) {
            this.logger.warn("serialize page token: {} error", pageToken, (Object)e);
            return null;
        }
    }

    protected P loadLastPageToken() {
        String pageTokenString = this.settingService.getTextValue(this.pageTokenKey);
        try {
            return (P)(EzyStrings.isBlank((String)pageTokenString) ? this.defaultPageToken() : this.objectMapper.readValue(pageTokenString, this.pageTokenType()));
        }
        catch (Exception e) {
            return this.defaultPageToken();
        }
    }

    protected abstract String getAppenderNamePrefix();

    protected abstract P defaultPageToken();

    protected abstract Class<P> pageTokenType();

    public void reload() {
        this.settingService.removeSetting(this.pageTokenKey);
        this.lastPageToken.set(null);
    }

    public String getName() {
        return this.getAppenderNamePrefix();
    }

    public int getPriority() {
        return 0;
    }

    public AdminDataAppender(ObjectMapper objectMapper, AdminSettingService settingService) {
        this.objectMapper = objectMapper;
        this.settingService = settingService;
    }
}

