/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.api;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.Api;
import com.tvd12.ezyhttp.server.core.annotation.Async;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoDelete;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.DoPost;
import com.tvd12.ezyhttp.server.core.annotation.DoPut;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.annotation.RequestBody;
import com.tvd12.ezyhttp.server.core.annotation.RequestParam;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.youngmonkeys.ezyplatform.admin.controller.service.AdminMediaControllerService;
import org.youngmonkeys.ezyplatform.admin.response.AdminMediaDetailsResponse;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.DefaultMediaFilter;
import org.youngmonkeys.ezyplatform.pagination.MediaFilter;
import org.youngmonkeys.ezyplatform.request.AddMediaFromUrlRequest;
import org.youngmonkeys.ezyplatform.request.UpdateMediaIncludeUrlRequest;
import org.youngmonkeys.ezyplatform.response.MediaResponse;
import org.youngmonkeys.ezyplatform.util.StringConverters;

@Api
@Authenticated
@EzyFeature(value="media_management")
@Controller(value="/api/v1")
public class AdminApiMediaController {
    private final AdminAdminService adminService;
    private final AdminMediaControllerService mediaControllerService;

    @Async
    @DoPost(value="/media/add")
    public void mediaAddPost(HttpServletRequest request, HttpServletResponse response, @AdminId long adminId, @RequestParam(value="avatar") boolean avatar, @RequestParam(value="notPublic") boolean notPublic) throws Exception {
        this.mediaControllerService.addMedia(request, response, adminId, avatar, notPublic);
    }

    @DoPost(value="/media/add-from-url")
    public MediaModel mediaAddFromUrlPost(@RequestBody AddMediaFromUrlRequest request, @RequestParam(value="notPublic") boolean notPublic) {
        return this.mediaControllerService.addMedia(0L, request, notPublic, UploadFrom.ADMIN);
    }

    @DoPut(value="/media/{id}")
    public ResponseEntity mediaIdPut(@PathVariable(value="id") long mediaId, @RequestBody UpdateMediaIncludeUrlRequest request) {
        this.mediaControllerService.updateMedia(mediaId, request);
        return ResponseEntity.noContent();
    }

    @DoDelete(value="/media/{id}")
    public ResponseEntity mediaMediaIdDelete(@PathVariable(value="id") long mediaId) {
        this.mediaControllerService.removeMedia(mediaId);
        return ResponseEntity.noContent();
    }

    @Async
    @DoGet(value="/media/{name}")
    public void mediaNameGet(RequestArguments requestArguments, @PathVariable(value="name") String name) throws Exception {
        this.mediaControllerService.getMedia(requestArguments, name);
    }

    @DoGet(value="/media/{id}/details")
    public AdminMediaDetailsResponse mediaIdDetailsGet(@PathVariable long mediaId) throws Exception {
        return this.mediaControllerService.getMediaDetailsResponse(mediaId);
    }

    @DoGet(value="/media/list")
    public PaginationModel<MediaResponse> mediaListGet(@AdminId long adminId, @AdminRoles AdminRolesProxy adminRoles, @RequestParam(value="type") MediaType type, @RequestParam(value="keyword") String keyword, @RequestParam(value="nextPageToken") String nextPageToken, @RequestParam(value="prevPageToken") String prevPageToken, @RequestParam(value="lastPage") boolean lastPage, @RequestParam(value="limit", defaultValue="30") int limit) {
        boolean allowAccessAllMedia = adminRoles.isSuperAdmin();
        if (!allowAccessAllMedia) {
            allowAccessAllMedia = this.adminService.isAllowAccessAllMedia(adminId);
        }
        if (allowAccessAllMedia) {
            return this.mediaControllerService.getMediaList((MediaFilter)DefaultMediaFilter.builder().type(type).prefixKeyword(StringConverters.trimOrNull((String)keyword)).build(), nextPageToken, prevPageToken, lastPage, limit);
        }
        return this.mediaControllerService.getMediaList((MediaFilter)DefaultMediaFilter.builder().type(type).prefixKeyword(StringConverters.trimOrNull((String)keyword)).ownerAdminId(Long.valueOf(adminId)).build(), nextPageToken, prevPageToken, lastPage, limit);
    }

    public AdminApiMediaController(AdminAdminService adminService, AdminMediaControllerService mediaControllerService) {
        this.adminService = adminService;
        this.mediaControllerService = mediaControllerService;
    }
}

