/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.data;

import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import org.youngmonkeys.ezyplatform.admin.model.AddAdminProjectModel;

public class ProjectInstallation {
    private long adminId;
    private String projectName;
    private String version;
    private String marketAccessToken;
    private boolean uploaded;
    private final EzyFuture future = new EzyFutureTask();
    private static final int DEFAULT_TIMEOUT = 120000;

    public static ProjectInstallation ofUploadFileName(long adminId, String uploadFileName) {
        String fileName = uploadFileName.substring(0, uploadFileName.lastIndexOf(46));
        int lastIndex = fileName.lastIndexOf(45);
        return ProjectInstallation.builder().adminId(adminId).uploaded(true).projectName(fileName.substring(0, lastIndex)).version(fileName.substring(lastIndex + 1)).build();
    }

    public void finish(Exception e) {
        if (e == null) {
            this.future.setResult((Object)Boolean.TRUE);
        } else {
            this.future.setException(e);
        }
    }

    public void await() throws Exception {
        this.future.get(120000L);
    }

    public String getFileName() {
        return this.projectName + "-" + this.version + ".zip";
    }

    public AddAdminProjectModel toAddProjectModel() {
        return AddAdminProjectModel.builder().projectName(this.projectName).version(this.version).adminId(this.adminId).build();
    }

    ProjectInstallation(long adminId, String projectName, String version, String marketAccessToken, boolean uploaded) {
        this.adminId = adminId;
        this.projectName = projectName;
        this.version = version;
        this.marketAccessToken = marketAccessToken;
        this.uploaded = uploaded;
    }

    public static ProjectInstallationBuilder builder() {
        return new ProjectInstallationBuilder();
    }

    public long getAdminId() {
        return this.adminId;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMarketAccessToken() {
        return this.marketAccessToken;
    }

    public boolean isUploaded() {
        return this.uploaded;
    }

    public static class ProjectInstallationBuilder {
        private long adminId;
        private String projectName;
        private String version;
        private String marketAccessToken;
        private boolean uploaded;

        ProjectInstallationBuilder() {
        }

        public ProjectInstallationBuilder adminId(long adminId) {
            this.adminId = adminId;
            return this;
        }

        public ProjectInstallationBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public ProjectInstallationBuilder version(String version) {
            this.version = version;
            return this;
        }

        public ProjectInstallationBuilder marketAccessToken(String marketAccessToken) {
            this.marketAccessToken = marketAccessToken;
            return this;
        }

        public ProjectInstallationBuilder uploaded(boolean uploaded) {
            this.uploaded = uploaded;
            return this;
        }

        public ProjectInstallation build() {
            return new ProjectInstallation(this.adminId, this.projectName, this.version, this.marketAccessToken, this.uploaded);
        }

        public String toString() {
            return "ProjectInstallation.ProjectInstallationBuilder(adminId=" + this.adminId + ", projectName=" + this.projectName + ", version=" + this.version + ", marketAccessToken=" + this.marketAccessToken + ", uploaded=" + this.uploaded + ")";
        }
    }
}

