/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.io.PropertiesFileProxy;

@EzySingleton
public class AdminPropertiesFileReader {
    private final FileReader propertiesFileReader;
    private final AdminFileSystemManager fileSystemManager;

    public String readAdminConfigContent() {
        return this.readPropertiesFileContent("admin/settings/config.properties");
    }

    public String readSocketConfigContent() {
        return this.readPropertiesFileContent("socket/settings/config.properties");
    }

    public Properties readSocketConfigProperties() {
        return this.propertiesFileReader.read(this.fileSystemManager.concatWithEzyHome("socket/settings/config.properties"));
    }

    public String readWebConfigContent() {
        return this.readPropertiesFileContent("web/settings/config.properties");
    }

    public String readPropertiesFileContent(String propertiesFile) {
        return PropertiesFileProxy.readToMultiLinesString((File)new File(this.fileSystemManager.concatWithEzyHome(propertiesFile)));
    }

    public AdminPropertiesFileReader(FileReader propertiesFileReader, AdminFileSystemManager fileSystemManager) {
        this.propertiesFileReader = propertiesFileReader;
        this.fileSystemManager = fileSystemManager;
    }
}

