/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.data.Target;
import org.youngmonkeys.ezyplatform.entity.TargetType;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminTargetInformationInteractor
extends EzyLoggable {
    private final ObjectMapper objectMapper;
    private static final String FILE_INFO = "info.txt";

    public Map<TargetType, Target> readTargetMap(File runtimeFolder) {
        return Arrays.stream(TargetType.values()).collect(Collectors.toMap(it -> it, it -> this.readTarget(runtimeFolder, (TargetType)it)));
    }

    public void saveTarget(File runtimeFolder, Target target) {
        FolderProxy.mkdir((File)runtimeFolder);
        TargetType targetType = target.getType();
        File targetFolder = Paths.get(runtimeFolder.toString(), targetType.getName()).toFile();
        FolderProxy.mkdir((File)targetFolder);
        File infoFile = Paths.get(targetFolder.getPath(), FILE_INFO).toFile();
        FolderProxy.createNewFile((File)infoFile);
        try {
            this.objectMapper.writeValue(infoFile, (Object)target);
        }
        catch (IOException e) {
            this.logger.error("write target information: {} failed", (Object)target, (Object)e);
        }
    }

    private Target readTarget(File runtimeFolder, TargetType targetType) {
        if (!runtimeFolder.exists()) {
            return this.defaultTarget(targetType);
        }
        File targetFolder = Paths.get(runtimeFolder.toString(), targetType.getName()).toFile();
        if (!targetFolder.exists()) {
            return this.defaultTarget(targetType);
        }
        File infoFile = Paths.get(targetFolder.getPath(), FILE_INFO).toFile();
        if (!infoFile.exists()) {
            return this.defaultTarget(targetType);
        }
        try {
            return (Target)this.objectMapper.readValue(infoFile, Target.class);
        }
        catch (IOException e) {
            throw new IllegalStateException("can not read file: " + infoFile, e);
        }
    }

    private Target defaultTarget(TargetType targetType) {
        Target target = new Target();
        target.setType(targetType);
        target.setActive(true);
        return target;
    }

    public AdminTargetInformationInteractor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

