/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.jdbc;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.io.File;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import org.youngmonkeys.ezyplatform.admin.data.Module;
import org.youngmonkeys.ezyplatform.admin.jdbc.AdminJdbcProxy;
import org.youngmonkeys.ezyplatform.admin.manager.AdminModuleManager;
import org.youngmonkeys.ezyplatform.admin.model.RunScriptHistoryModel;
import org.youngmonkeys.ezyplatform.admin.service.AdminRunScriptHistoryService;

@EzySingleton
public class AdminSqlScriptsRunner
extends EzyLoggable {
    private final AdminJdbcProxy jdbcProxy;
    private final AdminModuleManager moduleManager;
    private final AdminRunScriptHistoryService runScriptHistoryService;

    public void runProjectScripts(String projectName) throws Exception {
        try (Connection connection = this.jdbcProxy.createConnection();){
            this.runScripts(projectName, connection);
        }
    }

    private void runScripts(String projectName, Connection connection) throws Exception {
        Map<Module, List<File>> sqlScripFiles = this.moduleManager.listSqlScripFilesOfProject(projectName);
        for (Module module : sqlScripFiles.keySet()) {
            List<File> scriptFiles = sqlScripFiles.get(module);
            for (File scriptFile : scriptFiles) {
                this.runModuleScript(connection, module, scriptFile);
            }
        }
    }

    private void runModuleScript(Connection connection, Module module, File scriptFile) throws Exception {
        try {
            RunScriptHistoryModel history = RunScriptHistoryModel.builder().moduleType(module.getType().toString()).moduleName(module.getName()).scriptName(scriptFile.getName()).build();
            boolean hasRun = this.runScriptHistoryService.containsScript(history);
            if (!hasRun && this.jdbcProxy.runScriptFile(connection, scriptFile.toString())) {
                this.runScriptHistoryService.saveHistory(history);
            }
        }
        catch (Throwable e) {
            this.logger.error("module: {} ({}), can not run script file: {}", new Object[]{module.getName(), module.getType(), scriptFile.getName(), e});
            throw e;
        }
    }

    public AdminSqlScriptsRunner(AdminJdbcProxy jdbcProxy, AdminModuleManager moduleManager, AdminRunScriptHistoryService runScriptHistoryService) {
        this.jdbcProxy = jdbcProxy;
        this.moduleManager = moduleManager;
        this.runScriptHistoryService = runScriptHistoryService;
    }
}

