/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.validator;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import java.util.Collections;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.model.AdminModel;

@EzySingleton
public class AdminResetPasswordValidator {
    private final AdminAdminService adminService;

    public long validate(String username, String token, long tokenExpiredAt) {
        AdminModel admin = this.adminService.getAdminByUsername(username);
        if (admin == null) {
            throw new HttpNotFoundException(Collections.singletonMap("token", "notFound"));
        }
        boolean isInValidToken = false;
        if (EzyStrings.isBlank((String)token)) {
            isInValidToken = true;
        } else if (tokenExpiredAt == 0L) {
            isInValidToken = true;
        } else if (tokenExpiredAt < System.currentTimeMillis()) {
            isInValidToken = true;
        }
        if (isInValidToken) {
            throw new HttpNotFoundException(Collections.singletonMap("token", "notFound"));
        }
        long adminId = admin.getId();
        this.adminService.verifyResetPasswordToken(adminId, token, tokenExpiredAt);
        return adminId;
    }

    public AdminResetPasswordValidator(AdminAdminService adminService) {
        this.adminService = adminService;
    }
}

