/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.bean.impl;

import com.tvd12.ezyfox.bean.EzyBeanConfig;
import com.tvd12.ezyfox.bean.EzyBeanContext;
import com.tvd12.ezyfox.bean.EzyBeanContextAware;
import com.tvd12.ezyfox.bean.EzyBeanNameTranslator;
import com.tvd12.ezyfox.bean.EzyBeanNameTranslatorAware;
import com.tvd12.ezyfox.bean.EzyPackagesToScanAware;
import com.tvd12.ezyfox.bean.EzyPrototypeFactory;
import com.tvd12.ezyfox.bean.EzyPrototypeFactoryAware;
import com.tvd12.ezyfox.bean.EzyPrototypeSupplier;
import com.tvd12.ezyfox.bean.EzySingletonFactory;
import com.tvd12.ezyfox.bean.EzySingletonFactoryAware;
import com.tvd12.ezyfox.bean.annotation.EzyPrototype;
import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import com.tvd12.ezyfox.bean.impl.EzyBeanKey;
import com.tvd12.ezyfox.bean.impl.EzyBeanNameParser;
import com.tvd12.ezyfox.bean.impl.EzyByConstructorSingletonLoader;
import com.tvd12.ezyfox.bean.impl.EzyByFieldPrototypeSupplierLoader;
import com.tvd12.ezyfox.bean.impl.EzyByMethodPrototypeSupplierLoader;
import com.tvd12.ezyfox.bean.impl.EzyConfigurationFieldSingletonLoader;
import com.tvd12.ezyfox.bean.impl.EzyConfigurationLoader;
import com.tvd12.ezyfox.bean.impl.EzyConfigurationMethodSingletonLoader;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyPropertiesAware;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class EzySimpleConfigurationLoader
extends EzyLoggable
implements EzyConfigurationLoader {
    protected EzyClass clazz;
    protected Properties properties;
    protected EzyBeanContext context;
    protected EzyPrototypeFactory prototypeFactory;
    protected EzySingletonFactory singletonFactory;
    protected EzyBeanNameTranslator beanNameTranslator;
    protected Map<Class<?>, EzyMethod> singletonMethods;
    protected Map<EzyBeanKey, EzyMethod> singletonMethodByKey;

    @Override
    public EzyConfigurationLoader clazz(Class<?> configClass) {
        this.clazz = new EzyClass(configClass);
        this.singletonMethodByKey = this.mapSingletonKeyMethods();
        this.singletonMethods = EzyMaps.newHashMapNewKeys(this.singletonMethodByKey, EzyBeanKey::getType);
        return this;
    }

    @Override
    public EzyConfigurationLoader context(EzyBeanContext context) {
        this.context = context;
        this.properties = context.getProperties();
        this.singletonFactory = context.getSingletonFactory();
        this.prototypeFactory = context.getPrototypeFactory();
        this.beanNameTranslator = context.getBeanNameTranslator();
        return this;
    }

    @Override
    public void load() {
        Object configurator = this.newConfigurator();
        this.addSingletonByFields(configurator);
        this.addSingletonByMethods(configurator);
        this.addPrototypeByFields(configurator);
        this.addPrototypeByMethods(configurator);
    }

    private Object newConfigurator() {
        String beanName = EzyBeanNameParser.getSingletonName(this.clazz.getClazz());
        Object object = new EzyByConstructorSingletonLoader(beanName, this.clazz).load(this.context);
        if (object instanceof EzyBeanContextAware) {
            ((EzyBeanContextAware)object).setContext(this.context);
        }
        if (object instanceof EzyPropertiesAware) {
            ((EzyPropertiesAware)object).setProperties(this.properties);
        }
        if (object instanceof EzyPackagesToScanAware) {
            ((EzyPackagesToScanAware)object).setPackagesToScan(this.context.getPackagesToScan());
        }
        if (object instanceof EzySingletonFactoryAware) {
            ((EzySingletonFactoryAware)object).setSingletonFactory(this.singletonFactory);
        }
        if (object instanceof EzyPrototypeFactoryAware) {
            ((EzyPrototypeFactoryAware)object).setPrototypeFactory(this.prototypeFactory);
        }
        if (object instanceof EzyBeanNameTranslatorAware) {
            ((EzyBeanNameTranslatorAware)object).setBeanNameTranslator(this.beanNameTranslator);
        }
        if (object instanceof EzyBeanConfig) {
            ((EzyBeanConfig)object).config();
        }
        return object;
    }

    private void addSingletonByFields(Object configurator) {
        this.getSingletonFields().forEach(f -> this.addSingletonByField((EzyField)f, configurator));
    }

    private void addSingletonByField(EzyField field, Object configurator) {
        String beanName = EzyBeanNameParser.getSingletonName(field);
        Object current = this.singletonFactory.getSingleton(EzyBeanKey.of(beanName, field.getType()));
        if (current == null) {
            EzyConfigurationFieldSingletonLoader loader = new EzyConfigurationFieldSingletonLoader(beanName, field, configurator, this.singletonMethods);
            loader.load(this.context);
        }
    }

    private void addSingletonByMethods(Object configurator) {
        HashSet<EzyBeanKey> keys = new HashSet<EzyBeanKey>(this.singletonMethodByKey.keySet());
        for (EzyBeanKey key : keys) {
            EzyMethod method = this.singletonMethodByKey.remove(key);
            if (method == null) continue;
            this.logger.debug("add singleton of {} with method {}", (Object)key, (Object)method);
            this.addSingletonByMethod(method, configurator);
        }
    }

    private void addSingletonByMethod(EzyMethod method, Object configurator) {
        String beanName = EzyBeanNameParser.getSingletonName(method);
        Object current = this.singletonFactory.getSingleton(EzyBeanKey.of(beanName, method.getReturnType()));
        if (current == null) {
            EzyConfigurationMethodSingletonLoader loader = new EzyConfigurationMethodSingletonLoader(beanName, method, configurator, this.singletonMethods);
            loader.load(this.context);
        }
    }

    private void addPrototypeByFields(Object configurator) {
        this.getPrototypeFields().forEach(f -> this.addPrototypeByField((EzyField)f, configurator));
    }

    private void addPrototypeByField(EzyField field, Object configurator) {
        String beanName = EzyBeanNameParser.getPrototypeName(field);
        EzyPrototypeSupplier current = this.prototypeFactory.getSupplier(beanName, field.getType());
        if (current == null) {
            EzyByFieldPrototypeSupplierLoader loader = new EzyByFieldPrototypeSupplierLoader(beanName, field, configurator);
            loader.load(this.prototypeFactory);
        }
    }

    private void addPrototypeByMethods(Object configurator) {
        Map<EzyBeanKey, EzyMethod> methods = this.mapPrototypeKeyMethods();
        HashSet<EzyBeanKey> keys = new HashSet<EzyBeanKey>(methods.keySet());
        for (EzyBeanKey key : keys) {
            EzyMethod method = methods.remove(key);
            this.logger.debug("add prototype of {} with method {}", (Object)key, (Object)method);
            this.addPrototypeByMethod(method, configurator);
        }
    }

    private void addPrototypeByMethod(EzyMethod method, Object configurator) {
        String beanName = EzyBeanNameParser.getPrototypeName(method);
        EzyPrototypeSupplier current = this.prototypeFactory.getSupplier(beanName, method.getReturnType());
        if (current == null) {
            EzyByMethodPrototypeSupplierLoader loader = new EzyByMethodPrototypeSupplierLoader(beanName, method, configurator);
            loader.load(this.prototypeFactory);
        }
    }

    private List<EzyField> getSingletonFields() {
        return this.getBeanFields(EzySingleton.class);
    }

    private Map<EzyBeanKey, EzyMethod> mapSingletonKeyMethods() {
        return this.mapBeanKeyMethods(EzySingleton.class);
    }

    private List<EzyField> getPrototypeFields() {
        return this.getBeanFields(EzyPrototype.class);
    }

    private Map<EzyBeanKey, EzyMethod> mapPrototypeKeyMethods() {
        return this.mapBeanKeyMethods(EzyPrototype.class);
    }

    private List<EzyField> getBeanFields(Class<? extends Annotation> annClass) {
        return this.clazz.getPublicFields(f -> f.isAnnotated(annClass));
    }

    private Map<EzyBeanKey, EzyMethod> mapBeanKeyMethods(Class<? extends Annotation> annClass) {
        List methods = this.clazz.getPublicMethods(m -> m.isAnnotated(annClass) && m.getReturnType() != Void.TYPE);
        return EzyMaps.newHashMap((Collection)methods, it -> EzyBeanKey.of(EzyBeanNameParser.getSingletonName(it), it.getReturnType()));
    }
}

