/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.util;

import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.thymeleaf.util.Validate;

public final class ExpressionUtils {
    private static final Set<String> BLOCKED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("java.", "javax.", "jakarta.", "jdk.", "org.ietf.jgss.", "org.omg.", "org.w3c.dom.", "org.xml.sax.", "com.sun.", "sun."));
    private static final Set<String> ALLOWED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("java.time."));
    private static final Set<String> BLOCKED_TYPE_REFERENCE_PACKAGE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("com.squareup.javapoet.", "net.bytebuddy.", "net.sf.cglib.", "javassist.", "javax0.geci.", "org.apache.bcel.", "org.aspectj.", "org.javassist.", "org.mockito.", "org.objectweb.asm.", "org.objenesis.", "org.springframework.aot.", "org.springframework.asm.", "org.springframework.cglib.", "org.springframework.javapoet.", "org.springframework.objenesis."));
    private static final Set<String> ALLOWED_JAVA_CLASS_NAMES;
    private static final Set<Class<?>> ALLOWED_JAVA_CLASSES;
    private static final Set<String> ALLOWED_JAVA_SUPERS_NAMES;
    private static final Set<Class<?>> ALLOWED_JAVA_SUPERS;

    static boolean isJavaPackage(String typeName) {
        return typeName.charAt(0) == 'j' && typeName.charAt(4) == '.' && typeName.charAt(1) == 'a' && typeName.charAt(2) == 'v' && typeName.charAt(3) == 'a';
    }

    static boolean isPackageBlockedForAllPurposes(String typeName) {
        char c0 = typeName.charAt(0);
        if (c0 != 'c' && c0 != 'j' && c0 != 'o' && c0 != 's') {
            return false;
        }
        if (c0 == 'c') {
            return typeName.startsWith("com.sun.");
        }
        if (ExpressionUtils.isJavaPackage(typeName)) {
            return !typeName.startsWith("java.time.");
        }
        return BLOCKED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES.stream().anyMatch(prefix -> typeName.startsWith((String)prefix));
    }

    static boolean isPackageBlockedForTypeReference(String typeName) {
        if (ExpressionUtils.isPackageBlockedForAllPurposes(typeName)) {
            return true;
        }
        char c0 = typeName.charAt(0);
        if (c0 != 'c' && c0 != 'n' && c0 != 'j' && c0 != 'o') {
            return false;
        }
        if (c0 == 'c') {
            return typeName.startsWith("com.squareup.javapoet.");
        }
        return BLOCKED_TYPE_REFERENCE_PACKAGE_NAME_PREFIXES.stream().anyMatch(prefix -> typeName.startsWith((String)prefix));
    }

    public static boolean isTypeAllowed(String typeName) {
        Validate.notNull(typeName, "Type name cannot be null");
        if (!ExpressionUtils.isPackageBlockedForTypeReference(typeName)) {
            return true;
        }
        return ALLOWED_JAVA_CLASS_NAMES.contains(typeName) || ALLOWED_JAVA_SUPERS_NAMES.contains(typeName);
    }

    static boolean isMemberAllowedForInstanceOfType(Class<?> type, String memberName) {
        Validate.notNull(type, "Type cannot be null");
        String typeName = type.getName();
        if (!ExpressionUtils.isPackageBlockedForAllPurposes(typeName)) {
            return true;
        }
        if (type.isEnum() || type.isAnnotation()) {
            return true;
        }
        if (Proxy.isProxyClass(type)) {
            return true;
        }
        if (ALLOWED_JAVA_CLASSES.contains(type)) {
            return true;
        }
        return ALLOWED_JAVA_SUPERS.stream().filter(i -> i.isAssignableFrom(type)).anyMatch(i -> Arrays.stream(i.getDeclaredMethods()).anyMatch(m -> memberName.equals(m.getName())));
    }

    public static boolean isMemberAllowed(Object target, String memberName) {
        Validate.notNull(memberName, "Member name cannot be null");
        if (target == null) {
            return true;
        }
        if ("getClass".equals(memberName) || "toString".equals(memberName)) {
            return true;
        }
        if (target instanceof Class) {
            String targetTypeName = ((Class)target).getName();
            return "getName".equals(memberName) || ExpressionUtils.isTypeAllowed(targetTypeName);
        }
        return ExpressionUtils.isMemberAllowedForInstanceOfType(target.getClass(), memberName);
    }

    public static List<String> getBlockedClasses() {
        return BLOCKED_ALL_PURPOSES_PACKAGE_NAME_PREFIXES.stream().sorted().map(p -> String.format("%s*", p)).collect(Collectors.toList());
    }

    public static List<String> getAllowedClasses() {
        return Stream.concat(Stream.concat(ALLOWED_JAVA_CLASSES.stream().map(c -> c.getName()), ALLOWED_JAVA_SUPERS.stream().map(c -> c.getName())), Stream.of("java.time.*")).sorted().collect(Collectors.toList());
    }

    private ExpressionUtils() {
    }

    static {
        ALLOWED_JAVA_CLASSES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Character.class, Double.class, Enum.class, Float.class, Integer.class, Long.class, Math.class, Number.class, Short.class, String.class, BigDecimal.class, BigInteger.class, RoundingMode.class, ArrayList.class, LinkedList.class, HashMap.class, LinkedHashMap.class, HashSet.class, LinkedHashSet.class, Iterator.class, Enumeration.class, Locale.class, Properties.class, Date.class, Calendar.class, Optional.class));
        ALLOWED_JAVA_SUPERS = new HashSet<Class>(Arrays.asList(Collection.class, Iterable.class, List.class, Map.class, Map.Entry.class, Set.class, Calendar.class, Stream.class));
        ALLOWED_JAVA_CLASS_NAMES = ALLOWED_JAVA_CLASSES.stream().map(c -> c.getName()).collect(Collectors.toSet());
        ALLOWED_JAVA_SUPERS_NAMES = ALLOWED_JAVA_SUPERS.stream().map(c -> c.getName()).collect(Collectors.toSet());
    }
}

