/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.file;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.exception.EzyFileNotFoundException;
import com.tvd12.ezyfox.file.EzyFileFetcher;
import java.io.File;

public class EzySimpleFileFetcher
implements EzyFileFetcher {
    protected final boolean throwException;

    public EzySimpleFileFetcher() {
        this(EzySimpleFileFetcher.builder());
    }

    protected EzySimpleFileFetcher(Builder builder) {
        this.throwException = builder.throwException;
    }

    @Override
    public File get(String filePath) {
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        if (this.isThrowException()) {
            throw new EzyFileNotFoundException(file);
        }
        return null;
    }

    protected boolean isThrowException() {
        return this.throwException;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<EzyFileFetcher> {
        protected boolean throwException = true;

        public Builder throwException(boolean throwException) {
            this.throwException = throwException;
            return this;
        }

        public EzyFileFetcher build() {
            return new EzySimpleFileFetcher(this);
        }
    }
}

