/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.view;

import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyhttp.server.core.util.HttpServletRequests;
import com.tvd12.ezyhttp.server.core.view.View;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.model.MediaNameModel;
import org.youngmonkeys.ezyplatform.model.UserModel;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.UserService;
import org.youngmonkeys.ezyplatform.web.annotation.UserId;
import org.youngmonkeys.ezyplatform.web.view.WebViewLanguageDecorator;

public class WebViewDecorator
extends WebViewLanguageDecorator {
    @EzyAutoBind
    private UserService userService;
    @EzyAutoBind
    private MediaService mediaService;

    @Override
    public void decorate(HttpServletRequest request, View view) {
        super.decorate(request, view);
        this.setUserData(request, view);
    }

    protected void setUserData(HttpServletRequest request, View view) {
        String accessToken;
        Long userId = (Long)request.getAttribute(UserId.class.getName());
        if (userId == null && EzyStrings.isNotBlank((String)(accessToken = HttpServletRequests.getRequestValue((HttpServletRequest)request, (String)"accessToken")))) {
            userId = this.userService.getUserIdByAccessToken(accessToken);
        }
        if (userId == null) {
            return;
        }
        view.setVariable("userId", (Object)userId);
        UserModel user = (UserModel)view.getVariable("user");
        if (user == null) {
            user = this.userService.getUserById(userId.longValue());
        }
        if (user != null) {
            view.setVariable("user", (Object)user);
            view.setVariable("userUuid", (Object)user.getUuid());
            view.setVariable("loggedIn", (Object)true);
            MediaNameModel avatarImage = (MediaNameModel)view.getVariable("avatarImage");
            if (avatarImage == null) {
                avatarImage = this.mediaService.getMediaNameById(user.getAvatarImageId());
                if (avatarImage == null) {
                    avatarImage = MediaNameModel.builder().build();
                }
                view.setVariable("avatarImage", (Object)avatarImage);
            }
            this.decorateWithUserData(request, view, user);
        }
    }

    protected void decorateWithUserData(HttpServletRequest request, View view, UserModel user) {
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setMediaService(MediaService mediaService) {
        this.mediaService = mediaService;
    }
}

