/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

public final class ZipFileProxy {
    private ZipFileProxy() {
    }

    public static File unzipFile(File rootFolder, File zipFile) throws IOException {
        return ZipFileProxy.unzipFile(rootFolder, zipFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unzipFile(File rootFolder, File zipFile, boolean excludeParentFolder) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(Files.newInputStream(zipFile.toPath(), new OpenOption[0]));
        try {
            File file = ZipFileProxy.unzipStream(rootFolder, zipInputStream, excludeParentFolder);
            return file;
        }
        finally {
            zipInputStream.closeEntry();
            zipInputStream.close();
        }
    }

    public static File unzipStream(File rootFolder, ZipInputStream zipInputStream, boolean excludeParentFolder) throws IOException {
        ZipEntry zipEntry;
        File answer = null;
        byte[] buffer = new byte[1024];
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int index;
            String entryName = zipEntry.getName();
            if (entryName.contains("..")) continue;
            if (excludeParentFolder && (index = entryName.indexOf(47, 1)) > 0) {
                entryName = entryName.substring(index + 1);
            }
            File newFile = Paths.get(rootFolder.toString(), entryName).toFile();
            if (answer == null) {
                answer = newFile;
            }
            if (zipEntry.isDirectory()) {
                FolderProxy.mkdirs(newFile);
                continue;
            }
            FolderProxy.createNewFile(newFile);
            FileOutputStream fileOutputStream = new FileOutputStream(newFile);
            Throwable throwable = null;
            try {
                int readBytes;
                while ((readBytes = zipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, readBytes);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (fileOutputStream == null) continue;
                if (throwable != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                fileOutputStream.close();
            }
        }
        return answer;
    }
}

