/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.youngmonkeys.ezyplatform.model.NamedModel;
import org.youngmonkeys.ezyplatform.model.UserModel;

public class UserNameModel
implements NamedModel {
    private long userId;
    private String username;
    private String displayName;

    public static UserNameModel fromUserModel(UserModel model) {
        if (model == null) {
            return null;
        }
        return UserNameModel.builder().userId(model.getId()).username(model.getUsername()).displayName(model.getDisplayName()).build();
    }

    @JsonIgnore
    public String getNameAndUsername() {
        return this.getName() + "<" + this.username + ">";
    }

    UserNameModel(long userId, String username, String displayName) {
        this.userId = userId;
        this.username = username;
        this.displayName = displayName;
    }

    public static UserNameModelBuilder builder() {
        return new UserNameModelBuilder();
    }

    public long getUserId() {
        return this.userId;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public static class UserNameModelBuilder {
        private long userId;
        private String username;
        private String displayName;

        UserNameModelBuilder() {
        }

        public UserNameModelBuilder userId(long userId) {
            this.userId = userId;
            return this;
        }

        public UserNameModelBuilder username(String username) {
            this.username = username;
            return this;
        }

        public UserNameModelBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public UserNameModel build() {
            return new UserNameModel(this.userId, this.username, this.displayName);
        }

        public String toString() {
            return "UserNameModel.UserNameModelBuilder(userId=" + this.userId + ", username=" + this.username + ", displayName=" + this.displayName + ")";
        }
    }
}

