/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.pagination;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.youngmonkeys.ezyplatform.pagination.PaginationParameterConverter;

public class DefaultPaginationParameterConverter
implements PaginationParameterConverter {
    private final ObjectMapper objectMapper;

    @Override
    public String serialize(Object paginationParameter) {
        if (paginationParameter == null) {
            return null;
        }
        try {
            return this.objectMapper.writeValueAsString(paginationParameter);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid pagination parameter", e);
        }
    }

    @Override
    public <T> T deserialize(String pageToken, Class<T> paginationParameterType) {
        if (pageToken == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(pageToken, paginationParameterType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid pagination parameter value", e);
        }
    }

    @Override
    public <T> T deserialize(String pageToken, TypeReference<T> paginationParameterTypeReference) {
        if (pageToken == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(pageToken, paginationParameterTypeReference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid pagination parameter value", e);
        }
    }

    @Override
    public Map<String, Object> serializeToMap(Object paginationParameter) {
        if (paginationParameter == null) {
            return null;
        }
        return (Map)this.objectMapper.convertValue(paginationParameter, Map.class);
    }

    @Override
    public <T> T deserializeFromMap(Map<String, Object> value, Class<T> paginationParameterType) {
        if (value == null) {
            return null;
        }
        return (T)this.objectMapper.convertValue(value, paginationParameterType);
    }

    public DefaultPaginationParameterConverter(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

