/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyEntry;
import com.tvd12.reflections.util.Predicates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.util.Strings;

public interface DataMetaService {
    public void saveDataMeta(String var1, long var2, String var4, String var5);

    default public void saveDataMeta(String dataType, long dataId, String metaKey, Object metaValue) {
        this.saveDataMeta(dataType, dataId, metaKey, Strings.from(metaValue));
    }

    public void saveDataMeta(String var1, long var2, String var4, List<String> var5);

    default public void saveDataMeta(String dataType, long dataId, String metaKey, Collection<Object> metaValues) {
        this.saveDataMeta(dataType, dataId, metaKey, EzyLists.newArrayList(metaValues, Strings::from));
    }

    default public void saveDataMetaIfAbsent(String dataType, long dataId, String metaKey, Object metaValue) {
        this.saveDataMetaIfAbsent(dataType, dataId, metaKey, Strings.from(metaValue));
    }

    public void saveDataMetaIfAbsent(String var1, long var2, String var4, String var5);

    default public void saveDataMetaIfAbsent(String dataType, long dataId, String metaKey, List<String> metaValues) {
        metaValues.parallelStream().filter(Objects::nonNull).forEach(metaValue -> this.saveDataMetaIfAbsent(dataType, dataId, metaKey, (String)metaValue));
    }

    default public void saveDataMetaIfAbsent(String dataType, long dataId, String metaKey, Collection<Object> metaValues) {
        metaValues.parallelStream().filter(Objects::nonNull).forEach(metaValue -> this.saveDataMetaIfAbsent(dataType, dataId, metaKey, metaValue));
    }

    default public void saveDataMetaUniqueKey(String dataType, long dataId, String metaKey, Object metaValue) {
        this.saveDataMetaUniqueKey(dataType, dataId, metaKey, Strings.from(metaValue));
    }

    default public void saveDataMetaUniqueKey(String dataType, long dataId, String metaKey, String metaValue) {
        this.saveDataMetaUniqueKey(dataType, dataId, metaKey, metaValue, null);
    }

    public void saveDataMetaUniqueKey(String var1, long var2, String var4, String var5, String var6);

    default public void saveDataMetaUniqueKeys(String dataType, long dataId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveDataMetaUniqueKey(dataType, dataId, (String)e.getKey(), e.getValue()));
    }

    default public void saveDataMetaTextValueUniqueKeys(String dataType, long dataId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveDataMetaUniqueKey(dataType, dataId, (String)e.getKey(), "", Strings.from(e.getValue())));
    }

    public BigDecimal increaseDataMetaValue(String var1, long var2, String var4, BigDecimal var5);

    default public BigInteger increaseDataMetaValue(String dataType, long dataId, String metaKey, BigInteger value) {
        return this.increaseDataMetaValue(dataType, dataId, metaKey, new BigDecimal(value)).toBigInteger();
    }

    public boolean containsDataMeta(String var1, long var2, String var4, String var5);

    public long getDataIdByMeta(String var1, String var2, String var3);

    default public long getDataIdByMeta(String dataType, String metaKey, Object metaValue) {
        return this.getDataIdByMeta(dataType, metaKey, Strings.from(metaValue));
    }

    public String getMetaValueByDataIdAndMetaKey(String var1, long var2, String var4);

    public String getLatestMetaValueByDataIdAndMetaKey(String var1, long var2, String var4);

    default public String getMetaValueByDataIdAndMetaKeyOrDefault(String dataType, long dataId, String metaKey, String defaultValue) {
        String value = this.getMetaValueByDataIdAndMetaKey(dataType, dataId, metaKey);
        return value != null ? value : defaultValue;
    }

    public String getMetaTextValueByDataIdAndMetaKey(String var1, long var2, String var4);

    public String getLatestMetaTextValueByDataIdAndMetaKey(String var1, long var2, String var4);

    default public String getMetaTextValueByDataIdAndMetaKeyOrDefault(String dataType, long dataId, String metaKey, String defaultValue) {
        String value = this.getMetaTextValueByDataIdAndMetaKey(dataType, dataId, metaKey);
        return value != null ? value : defaultValue;
    }

    default public BigDecimal getMetaDecimalValueByDataIdAndMetaKey(String dataType, long dataId, String metaKey) {
        String value = this.getMetaValueByDataIdAndMetaKey(dataType, dataId, metaKey);
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }

    default public BigInteger getMetaIntegerValueByDataIdAndMetaKey(String dataType, long dataId, String metaKey) {
        String value = this.getMetaValueByDataIdAndMetaKey(dataType, dataId, metaKey);
        return value != null ? new BigInteger(value) : BigInteger.ZERO;
    }

    public List<String> getMetaValuesByDataIdAndMetaKey(String var1, long var2, String var4, int var5);

    default public <T> List<T> getMetaValuesByDataIdAndMetaKey(String dataType, long dataId, String metaKey, int limit, Function<String, T> valueConverter) {
        return EzyLists.newArrayList(this.getMetaValuesByDataIdAndMetaKey(dataType, dataId, metaKey, limit), valueConverter);
    }

    public Map<String, String> getDataMetaValues(String var1, long var2);

    public Map<String, String> getDataMetaTextValues(String var1, long var2);

    public Map<String, Long> getDataIdMapByMetaValues(String var1, String var2, Collection<String> var3);

    public Map<Long, String> getDataMetaValueMapByDataIds(String var1, Collection<Long> var2, String var3);

    default public <T> Map<Long, T> getDataMetaValueMapByDataIds(String dataType, Collection<Long> dataIds, String metaKey, Function<String, T> valueConverter) {
        return this.getDataMetaValueMapByDataIds(dataType, dataIds, metaKey, Predicates.alwaysTrue(), valueConverter);
    }

    default public <T> Map<Long, T> getDataMetaValueMapByDataIds(String dataType, Collection<Long> dataIds, String metaKey, Predicate<String> valueFilter, Function<String, T> valueConverter) {
        return this.getDataMetaValueMapByDataIds(dataType, dataIds, metaKey).entrySet().stream().filter(e -> e.getValue() != null).filter(e -> valueFilter.test((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> valueConverter.apply((String)e.getValue())));
    }

    public Map<String, String> getDataMetaValueMapByDataIdAndMetaKeys(String var1, long var2, Collection<String> var4);

    default public Map<String, String> getLatestMetaValueMapByDataIdAndMetaKeys(String dataType, long dataId, Collection<String> metaKeys) {
        return metaKeys.parallelStream().map(it -> EzyEntry.of((Object)it, (Object)this.getLatestMetaValueByDataIdAndMetaKey(dataType, dataId, (String)it))).filter(it -> it.getValue() != null).collect(Collectors.toMap(EzyEntry::getKey, EzyEntry::getValue));
    }

    public Map<Long, String> getDataMetaTextValueMapByDataIds(String var1, Collection<Long> var2, String var3);

    default public Map<Long, BigDecimal> getDataMetaBigDecimalValueMapByDataIds(String dataType, Collection<Long> dataIds, String metaKey) {
        return this.getDataMetaValueMapByDataIds(dataType, dataIds, metaKey, EzyStrings::isNotBlank, BigDecimal::new);
    }

    default public Map<Long, BigInteger> getDataMetaBigIntegerValueMapByDataIds(String dataType, Collection<Long> dataIds, String metaKey) {
        return this.getDataMetaValueMapByDataIds(dataType, dataIds, metaKey, EzyStrings::isNotBlank, BigInteger::new);
    }
}

