/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.util.Next;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.entity.AdminMeta;
import org.youngmonkeys.ezyplatform.repo.AdminMetaRepository;
import org.youngmonkeys.ezyplatform.repo.AdminMetaTransactionalRepository;
import org.youngmonkeys.ezyplatform.service.AdminMetaService;
import org.youngmonkeys.ezyplatform.util.Strings;

public class DefaultAdminMetaService
implements AdminMetaService {
    private final AdminMetaRepository adminMetaRepository;
    private final AdminMetaTransactionalRepository adminMetaTransactionalRepository;

    @Override
    public void saveAdminMeta(long adminId, String metaKey, String metaValue) {
        AdminMeta entity = new AdminMeta();
        entity.setAdminId(adminId);
        entity.setMetaKey(metaKey);
        entity.setMetaValue(metaValue);
        entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
        this.adminMetaRepository.save(entity);
    }

    @Override
    public void saveAdminMeta(long adminId, String metaKey, List<String> metaValues) {
        List entities = EzyLists.newArrayList(metaValues, metaValue -> {
            AdminMeta entity = new AdminMeta();
            entity.setAdminId(adminId);
            entity.setMetaKey(metaKey);
            entity.setMetaValue((String)metaValue);
            entity.setMetaNumberValue(Strings.toBigIntegerOrZero(metaValue));
            return entity;
        });
        this.adminMetaRepository.save(entities);
    }

    @Override
    public void saveAdminMetaUniqueKey(long adminId, String metaKey, String metaValue, String metaTextValue) {
        this.adminMetaTransactionalRepository.saveAdminMetaUniqueKey(adminId, metaKey, metaValue, metaTextValue);
    }

    @Override
    public void saveAdminMetaIfAbsent(long adminId, String metaKey, String metaValue) {
        this.adminMetaTransactionalRepository.saveAdminMetaUniqueKeyValue(adminId, metaKey, metaValue);
    }

    @Override
    public BigDecimal increaseAdminMetaValue(long adminId, String metaKey, BigDecimal value) {
        return this.adminMetaTransactionalRepository.increaseMetaValue(adminId, metaKey, value);
    }

    @Override
    public boolean containsAdminMeta(long adminId, String metaKey, String metaValue) {
        return this.adminMetaRepository.findByAdminIdAndMetaKeyAndMetaValue(adminId, metaKey, metaValue).isPresent();
    }

    @Override
    public long getAdminIdByMeta(String metaKey, String metaValue) {
        return this.adminMetaRepository.findByMetaKeyAndMetaValue(metaKey, metaValue).map(AdminMeta::getAdminId).orElse(0L);
    }

    @Override
    public String getMetaValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        return this.adminMetaRepository.findByAdminIdAndMetaKey(adminId, metaKey).map(AdminMeta::getMetaValue).orElse(null);
    }

    @Override
    public String getLatestMetaValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        return this.adminMetaRepository.findByAdminIdAndMetaKeyOrderByIdDesc(adminId, metaKey).map(AdminMeta::getMetaValue).orElse(null);
    }

    @Override
    public String getMetaTextValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        return this.adminMetaRepository.findByAdminIdAndMetaKey(adminId, metaKey).map(AdminMeta::getMetaTextValue).orElse(null);
    }

    @Override
    public String getLatestMetaTextValueByAdminIdAndMetaKey(long adminId, String metaKey) {
        return this.adminMetaRepository.findByAdminIdAndMetaKeyOrderByIdDesc(adminId, metaKey).map(AdminMeta::getMetaTextValue).orElse(null);
    }

    @Override
    public List<String> getMetaValuesByAdminIdAndMetaKey(long adminId, String metaKey, int limit) {
        return EzyLists.newArrayList(this.adminMetaRepository.findByAdminIdAndMetaKey(adminId, metaKey, Next.limit((long)limit)), AdminMeta::getMetaValue);
    }

    @Override
    public Map<String, String> getAdminMetaValues(long adminId) {
        return this.adminMetaRepository.findByAdminId(adminId).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(AdminMeta::getMetaKey, AdminMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<String, String> getAdminMetaTextValues(long adminId) {
        return this.adminMetaRepository.findByAdminId(adminId).stream().filter(it -> it.getMetaTextValue() != null).collect(Collectors.toMap(AdminMeta::getMetaKey, AdminMeta::getMetaTextValue, (o, n) -> n));
    }

    @Override
    public Map<String, Long> getAdminIdMapByMetaValues(String metaKey, Collection<String> metaValues) {
        if (metaValues.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminMetaRepository.findByMetaKeyAndMetaValueIn(metaKey, metaValues).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(AdminMeta::getMetaValue, AdminMeta::getAdminId, (o, n) -> n));
    }

    @Override
    public Map<Long, String> getAdminMetaValueMapByAdminIds(Collection<Long> adminIds, String metaKey) {
        if (adminIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminMetaRepository.findByAdminIdInAndMetaKey(adminIds, metaKey).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(AdminMeta::getAdminId, AdminMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<String, String> getAdminMetaValueMapByAdminIdAndMetaKeys(long adminId, Collection<String> metaKeys) {
        if (metaKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminMetaRepository.findByAdminIdAndMetaKeyIn(adminId, metaKeys).stream().filter(it -> it.getMetaValue() != null).collect(Collectors.toMap(AdminMeta::getMetaKey, AdminMeta::getMetaValue, (o, n) -> n));
    }

    @Override
    public Map<Long, String> getAdminMetaTextValueMapByAdminIds(Collection<Long> adminIds, String metaKey) {
        if (adminIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.adminMetaRepository.findByAdminIdInAndMetaKey(adminIds, metaKey).stream().filter(it -> it.getMetaTextValue() != null).collect(Collectors.toMap(AdminMeta::getAdminId, AdminMeta::getMetaTextValue, (o, n) -> n));
    }

    public DefaultAdminMetaService(AdminMetaRepository adminMetaRepository, AdminMetaTransactionalRepository adminMetaTransactionalRepository) {
        this.adminMetaRepository = adminMetaRepository;
        this.adminMetaTransactionalRepository = adminMetaTransactionalRepository;
    }
}

