/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.util.Map;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.data.TitleContent;
import org.youngmonkeys.ezyplatform.entity.ContentTemplate;
import org.youngmonkeys.ezyplatform.model.ContentTemplateModel;
import org.youngmonkeys.ezyplatform.repo.ContentTemplateRepository;
import org.youngmonkeys.ezyplatform.service.ContentTemplateService;

public class DefaultContentTemplateService
implements ContentTemplateService {
    private final ContentTemplateRepository contentTemplateRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;

    @Override
    public ContentTemplateModel getTemplateById(long templateId) {
        return this.entityToModelConverter.toModel((ContentTemplate)this.contentTemplateRepository.findById(templateId));
    }

    @Override
    public ContentTemplateModel getTemplateByTypeAndName(String templateType, String templateName) {
        return this.entityToModelConverter.toModel(this.contentTemplateRepository.findByTemplateTypeAndTemplateName(templateType, templateName));
    }

    @Override
    public boolean containsTemplateByTypeAndName(String templateType, String templateName) {
        return this.contentTemplateRepository.countByTemplateTypeAndTemplateName(templateType, templateName) > 0;
    }

    @Override
    public TitleContent makeTitleContent(String templateType, String templateName, Map<String, Object> parameters) {
        ContentTemplateModel template = this.getTemplateByTypeAndName(templateType, templateName);
        return TitleContent.fromTemplates(template.getTitleTemplate(), template.getContentTemplate(), parameters);
    }

    public DefaultContentTemplateService(ContentTemplateRepository contentTemplateRepository, DefaultEntityToModelConverter entityToModelConverter) {
        this.contentTemplateRepository = contentTemplateRepository;
        this.entityToModelConverter = entityToModelConverter;
    }
}

