/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import java.io.File;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.data.ImageSize;
import org.youngmonkeys.ezyplatform.entity.Media;
import org.youngmonkeys.ezyplatform.entity.MediaType;
import org.youngmonkeys.ezyplatform.entity.UploadFrom;
import org.youngmonkeys.ezyplatform.exception.MediaNotFoundException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.io.ImageProxy;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.model.AddMediaModel;
import org.youngmonkeys.ezyplatform.model.MediaModel;
import org.youngmonkeys.ezyplatform.model.UniqueDataModel;
import org.youngmonkeys.ezyplatform.model.UpdateMediaModel;
import org.youngmonkeys.ezyplatform.repo.MediaRepository;
import org.youngmonkeys.ezyplatform.service.MediaService;
import org.youngmonkeys.ezyplatform.service.UniqueDataService;

public class DefaultMediaService
implements MediaService {
    private final FileSystemManager fileSystemManager;
    private final UniqueDataService uniqueDataService;
    private final MediaRepository mediaRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public MediaModel addMedia(AddMediaModel model) {
        return this.addMedia(model, UploadFrom.ADMIN);
    }

    @Override
    public MediaModel addMedia(AddMediaModel model, UploadFrom uploadFrom) {
        Media entity = this.modelToEntityConverter.toEntity(model, uploadFrom);
        this.mediaRepository.save(entity);
        long mediaId = entity.getId();
        if (model.isSaveDuration()) {
            this.saveMediaDurationInMinutes(mediaId, model.getDurationInMinutes());
        }
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public void updateMedia(UpdateMediaModel model) {
        this.updateMedia(false, 0L, model);
    }

    @Override
    public void updateMedia(long userId, UpdateMediaModel model) {
        this.updateMedia(true, userId, model);
    }

    @Override
    public void updateMedia(boolean byUser, long userId, UpdateMediaModel model) {
        Media entity;
        Media media = entity = model.getMediaId() > 0L ? (Media)this.mediaRepository.findById(model.getMediaId()) : (Media)this.mediaRepository.findByField("name", model.getMediaName());
        if (entity == null || byUser && entity.getOwnerUserId() != userId) {
            throw new MediaNotFoundException(model.getMediaId(), model.getMediaName());
        }
        this.modelToEntityConverter.mergeToEntity(model, entity);
        this.mediaRepository.save(entity);
        long mediaId = entity.getId();
        if (model.isUpdateDuration()) {
            this.saveMediaDurationInMinutes(mediaId, model.getDurationInMinutes());
        }
    }

    @Override
    public void saveMediaDurationInMinutes(long mediaId, BigDecimal duration) {
        this.uniqueDataService.saveDataMeta(UniqueDataModel.builder().dataType("ezy_medias").dataId(mediaId).uniqueKey("durationInMinutes").decimalValue(duration != null ? duration : BigDecimal.ZERO).build());
    }

    @Override
    public void updateMediaOwner(long mediaId, long ownerUserId) {
        this.mediaRepository.updateOwnerUserId(mediaId, ownerUserId);
    }

    @Override
    public MediaModel removeMedia(long mediaId) {
        return this.removeMedia(false, 0L, mediaId, null);
    }

    @Override
    public MediaModel removeMedia(long userId, String mediaName) {
        return this.removeMedia(true, userId, 0L, mediaName);
    }

    @Override
    public MediaModel removeMedia(boolean byUser, long userId, long mediaId, String mediaName) {
        Media entity;
        Media media = entity = mediaId > 0L ? (Media)this.mediaRepository.findById(mediaId) : (Media)this.mediaRepository.findByField("name", mediaName);
        if (entity == null || byUser && entity.getOwnerUserId() != userId) {
            throw new MediaNotFoundException(mediaId, mediaName);
        }
        this.mediaRepository.delete(entity.getId());
        return this.entityToModelConverter.toModel(entity);
    }

    @Override
    public boolean containsMedia(long mediaId) {
        return this.mediaRepository.containsById(mediaId);
    }

    @Override
    public MediaModel getMediaById(long mediaId) {
        if (mediaId <= 0L) {
            return null;
        }
        return this.mediaRepository.findByIdOptional(mediaId).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public MediaModel getMediaByName(String mediaName) {
        return this.mediaRepository.findByFieldOptional("name", mediaName).map(this.entityToModelConverter::toModel).orElse(null);
    }

    @Override
    public Map<Long, MediaModel> getMediaMapByIds(Collection<Long> mediaIds) {
        if (mediaIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.mediaRepository.findListByIds(mediaIds).stream().collect(Collectors.toMap(Media::getId, this.entityToModelConverter::toModel, (o, n) -> n));
    }

    @Override
    public long getMediaFileLength(MediaType mediaType, String mediaName) {
        long fileLength = this.getMediaFileLengthOrNegative(mediaType, mediaName);
        if (fileLength >= 0L) {
            return fileLength;
        }
        throw new ResourceNotFoundException("media");
    }

    @Override
    public long getMediaFileLengthOrNegative(MediaType mediaType, String mediaName) {
        File mediaFile = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), mediaName);
        if (mediaFile.exists()) {
            return mediaFile.length();
        }
        return -1L;
    }

    @Override
    public long getMediaFileLengthOrZero(File mediaFile) {
        if (mediaFile.exists()) {
            return mediaFile.length();
        }
        return 0L;
    }

    @Override
    public ImageSize getMediaImageSize(String imageName, MediaType mediaType) {
        ImageSize imageSize = this.getMediaImageSizeOrNull(imageName, mediaType);
        if (imageSize != null) {
            return imageSize;
        }
        throw new ResourceNotFoundException("media");
    }

    @Override
    public ImageSize getMediaImageSize(long mediaId) {
        if (mediaId <= 0L) {
            throw new ResourceNotFoundException("media");
        }
        Media media = (Media)this.mediaRepository.findById(mediaId);
        if (media == null) {
            throw new ResourceNotFoundException("media");
        }
        return this.getMediaImageSize(media.getName(), media.getType());
    }

    @Override
    public ImageSize getMediaImageSizeOrNull(String imageName, MediaType mediaType) {
        File mediaFile = this.fileSystemManager.getMediaFilePath(mediaType.getFolder(), imageName);
        if (mediaFile.exists()) {
            return ImageProxy.getImageSize(mediaFile);
        }
        return null;
    }

    @Override
    public ImageSize getMediaImageSizeOrDefault(File mediaFile) {
        if (mediaFile.exists()) {
            return ImageProxy.getImageSize(mediaFile);
        }
        return ImageSize.ZERO;
    }

    @Override
    public BigDecimal getMediaDurationInMinutes(long mediaId) {
        return this.uniqueDataService.getUniqueDataValueByDataTypeAndDataIdAndUniqueKey("ezy_medias", mediaId, "durationInMinutes", UniqueDataModel::getDecimalValue, BigDecimal.ZERO);
    }

    @Override
    public Map<Long, BigDecimal> getMediaDurationInMinutesByIds(Collection<Long> mediaIds) {
        return this.uniqueDataService.getUniqueDataValueMapByDataTypeAndDataIdsAndUniqueKey("ezy_medias", mediaIds, "durationInMinutes", UniqueDataModel::getDecimalValue);
    }

    public DefaultMediaService(FileSystemManager fileSystemManager, UniqueDataService uniqueDataService, MediaRepository mediaRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.fileSystemManager = fileSystemManager;
        this.uniqueDataService = uniqueDataService;
        this.mediaRepository = mediaRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

