/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.security.EzyBase64;
import java.util.Collections;
import java.util.List;
import org.youngmonkeys.ezyplatform.data.PaginationParameter;
import org.youngmonkeys.ezyplatform.model.PaginationModel;
import org.youngmonkeys.ezyplatform.pagination.OffsetPaginationParameter;
import org.youngmonkeys.ezyplatform.rx.Reactive;
import org.youngmonkeys.ezyplatform.rx.RxOperation;
import org.youngmonkeys.ezyplatform.rx.RxValueMap;

public abstract class PaginationService<T, F, P> {
    public final PaginationModel<T> getFirstPage(int limit) {
        return this.getFirstPage(null, limit);
    }

    public final PaginationModel<T> getFirstPage(F filter, int limit) {
        return this.getNextPage(filter, null, limit);
    }

    public final PaginationModel<T> getNextPage(String pageToken, int limit) {
        return this.getNextPage(null, pageToken, limit);
    }

    public final PaginationModel<T> getNextPage(F filter, String pageToken, int limit) {
        P paginationParameter = this.doDeserializePageToken(pageToken);
        if (paginationParameter == null) {
            paginationParameter = this.defaultFirstPaginationParameter();
        }
        P paginationParameterFinal = paginationParameter;
        int limitPlusOne = limit + 1;
        return Reactive.multiple().registerRx("listPlusOne", this.getNextItems(filter, paginationParameterFinal, limitPlusOne)).register("total", () -> this.getTotalItems(filter)).blockingGet(map -> this.toNextPageModel((RxValueMap)map, paginationParameterFinal, limit));
    }

    public final PaginationModel<T> getLastPage(int limit) {
        return this.getLastPage(null, limit);
    }

    public final PaginationModel<T> getLastPage(F filter, int limit) {
        return this.getPreviousPage(filter, null, limit);
    }

    public final PaginationModel<T> getPreviousPage(String pageToken, int limit) {
        return this.getPreviousPage(null, pageToken, limit);
    }

    public final PaginationModel<T> getPreviousPage(F filter, String pageToken, int limit) {
        long tmpTotalItems = -1L;
        P paginationParameter = this.doDeserializePageToken(pageToken);
        if (paginationParameter == null) {
            tmpTotalItems = this.getTotalItems(filter);
            paginationParameter = this.defaultLastPaginationParameter(tmpTotalItems, limit);
        }
        P paginationParameterFinal = paginationParameter;
        int limitPlusOne = limit + 1;
        long totalItems = tmpTotalItems;
        return Reactive.multiple().registerRx("listPlusOne", this.getPreviousItems(filter, paginationParameterFinal, limitPlusOne)).register("total", () -> totalItems >= 0L ? totalItems : this.getTotalItems(filter)).blockingGet(map -> this.toPreviousPageModel((RxValueMap)map, paginationParameterFinal, limit));
    }

    private PaginationModel<T> toNextPageModel(RxValueMap map, P paginationParameter, int limit) {
        PaginationModel.PageToken pageToken;
        Object lastPageTokenItem;
        List listPlusOne = (List)map.get("listPlusOne");
        List list = EzyLists.take((List)listPlusOne, (int)limit);
        boolean hasNext = listPlusOne.size() > limit;
        boolean hasPrev = !this.isEmptyPaginationParameter(paginationParameter) && list.size() > 0;
        Object nextPageTokenItem = hasNext ? EzyLists.last((List)list) : null;
        Object object = lastPageTokenItem = hasPrev ? EzyLists.first((List)list) : null;
        if (paginationParameter instanceof OffsetPaginationParameter) {
            OffsetPaginationParameter offsetPaginationParameter = (OffsetPaginationParameter)paginationParameter;
            pageToken = PaginationModel.PageToken.builder().next(this.doSerializeToOffsetPageToken(offsetPaginationParameter.nextOffset(limit), nextPageTokenItem)).prev(this.doSerializeToOffsetPageToken(offsetPaginationParameter.previousOffset(limit), lastPageTokenItem)).build();
        } else {
            pageToken = PaginationModel.PageToken.builder().next(this.doSerializeToPageToken(paginationParameter, nextPageTokenItem)).prev(this.doSerializeToPageToken(paginationParameter, lastPageTokenItem)).build();
        }
        return PaginationModel.builder().items(list).count(list.size()).total((Long)map.get("total")).timestamp(this.getTimestamp()).pageToken(pageToken).continuation(PaginationModel.Continuation.builder().hasNext(hasNext).hasPrevious(hasPrev).build()).build();
    }

    private PaginationModel<T> toPreviousPageModel(RxValueMap map, P paginationParameter, int limit) {
        PaginationModel.PageToken pageToken;
        Object lastPageTokenItem;
        boolean hasPrev;
        boolean hasNext;
        List list;
        OffsetPaginationParameter offsetPaginationParameter = null;
        if (paginationParameter instanceof OffsetPaginationParameter) {
            offsetPaginationParameter = (OffsetPaginationParameter)paginationParameter;
        }
        List listPlusOne = (List)map.get("listPlusOne");
        if (offsetPaginationParameter != null) {
            int offset = offsetPaginationParameter.getOffset();
            int count = offset >= 0 ? limit : Math.max(offset + limit, 0);
            list = EzyLists.take((List)listPlusOne, (int)count);
            hasNext = listPlusOne.size() > count;
            hasPrev = offset > 0;
        } else {
            list = EzyLists.take((List)listPlusOne, (int)limit);
            hasNext = !this.isEmptyPaginationParameter(paginationParameter) && list.size() > 0;
            hasPrev = listPlusOne.size() > limit;
        }
        Object nextPageTokenItem = hasNext ? EzyLists.first((List)list) : null;
        Object object = lastPageTokenItem = hasPrev ? EzyLists.last((List)list) : null;
        if (offsetPaginationParameter != null) {
            pageToken = PaginationModel.PageToken.builder().next(this.doSerializeToOffsetPageToken(offsetPaginationParameter.nextOffset(limit), nextPageTokenItem)).prev(this.doSerializeToOffsetPageToken(offsetPaginationParameter.previousOffset(limit), lastPageTokenItem)).build();
        } else {
            Collections.reverse(list);
            pageToken = PaginationModel.PageToken.builder().next(this.doSerializeToPageToken(paginationParameter, nextPageTokenItem)).prev(this.doSerializeToPageToken(paginationParameter, lastPageTokenItem)).build();
        }
        long totalItems = (Long)map.get("total");
        return PaginationModel.builder().items(list).count(list.size()).total(totalItems).timestamp(this.getTimestamp()).pageToken(pageToken).continuation(PaginationModel.Continuation.builder().hasNext(hasNext).hasPrevious(hasPrev).build()).build();
    }

    private RxOperation getNextItems(F filter, P paginationParameter, int limit) {
        return paginationParameter == null ? this.getFirstItems(filter, limit) : this.getNextItemsExclusive(filter, paginationParameter, limit);
    }

    protected abstract RxOperation getFirstItems(F var1, int var2);

    protected abstract RxOperation getNextItemsExclusive(F var1, P var2, int var3);

    protected abstract RxOperation getPreviousItemsExclusive(F var1, P var2, int var3);

    private RxOperation getPreviousItems(F filter, P paginationParameter, int limit) {
        return paginationParameter == null ? this.getLastItems(filter, limit) : this.getPreviousItemsExclusive(filter, paginationParameter, limit);
    }

    protected abstract RxOperation getLastItems(F var1, int var2);

    protected abstract long getTotalItems(F var1);

    protected long getTimestamp() {
        return System.currentTimeMillis();
    }

    private String doSerializeToPageToken(P paginationParameter, T value) {
        return value == null ? null : EzyBase64.encodeUtf((String)this.serializeToPageToken(paginationParameter, value));
    }

    private String doSerializeToOffsetPageToken(long offset, T value) {
        return value == null ? null : EzyBase64.encodeUtf((String)String.valueOf(offset));
    }

    protected String serializeToPageToken(P paginationParameter, T value) {
        return this.serializeToPageToken(value);
    }

    protected String serializeToPageToken(T value) {
        return null;
    }

    private P doDeserializePageToken(String pageToken) {
        return pageToken == null ? this.defaultPaginationParameter() : this.deserializePageToken(EzyBase64.decodeUtf((String)pageToken));
    }

    protected P defaultPaginationParameter() {
        return null;
    }

    protected P defaultFirstPaginationParameter() {
        return null;
    }

    protected P defaultLastPaginationParameter(long totalItems, int limit) {
        return null;
    }

    protected abstract P deserializePageToken(String var1);

    protected boolean isEmptyPaginationParameter(Object paginationParameter) {
        if (paginationParameter == null) {
            return true;
        }
        if (paginationParameter instanceof PaginationParameter) {
            return ((PaginationParameter)paginationParameter).isEmpty();
        }
        return false;
    }
}

