/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.util;

import com.tvd12.ezyfox.io.EzyDates;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.reflections.util.Predicates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.function.Predicate;

public final class Strings {
    public static final String SPECIAL_CHARACTERS = "!\"#$%&'()*+,-./:;<=>?@[\\\\]^_`{|}~";

    private Strings() {
    }

    public static String from(Object value) {
        return value != null ? value.toString() : null;
    }

    public static String toLowerDashCase(String str) {
        return EzyStrings.isBlank((String)str) ? str : str.replace(' ', '-').toLowerCase();
    }

    public static String entryToString(Map.Entry<?, ?> entry) {
        String key = entry.getKey().toString();
        String value = entry.getValue() != null ? entry.getValue().toString() : null;
        return value != null ? key.trim() + "=" + value.trim() : key.trim() + "=";
    }

    public static boolean startsWithIgnoreSpaces(String str, String prefix) {
        int k;
        char ch;
        int i;
        for (i = 0; i < str.length() && ((ch = str.charAt(i)) == ' ' || ch == '\t'); ++i) {
        }
        for (k = 0; k < prefix.length() && i < str.length(); ++k, ++i) {
            if (prefix.charAt(k) == str.charAt(i)) continue;
            return false;
        }
        return k >= prefix.length();
    }

    public static boolean containInvalidSpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\n' || ch == '\t') {
                return true;
            }
            if (ch != ' ' || i >= str.length() - 1 || str.charAt(i + 1) != ' ') continue;
            return true;
        }
        return false;
    }

    public static String substring(String str, int from, int to) {
        return str.substring(Math.max(from, 0), Math.min(to, str.length()));
    }

    public static String substringLast(String str, int lastIndex, int length) {
        int from = lastIndex > length ? lastIndex - length : 0;
        return str.substring(from, lastIndex);
    }

    public static boolean endsWith(String str, int endIndex, String endStr) {
        int fromIndex = endIndex - endStr.length();
        if (fromIndex < 0) {
            return false;
        }
        int i = fromIndex;
        int k = 0;
        while (i < endIndex) {
            if (str.charAt(i) != endStr.charAt(k)) {
                return false;
            }
            ++i;
            ++k;
        }
        return true;
    }

    public static String hideSensitiveInformation(String str, int startHidden, int hiddenLength) {
        if (startHidden >= str.length()) {
            return str;
        }
        StringBuilder builder = new StringBuilder().append(str, 0, startHidden).append("***");
        int end = startHidden + hiddenLength;
        if (end < str.length() - 1) {
            builder.append(str.substring(end));
        }
        return builder.toString();
    }

    public static String emptyIfNull(String str) {
        return str != null ? str : "";
    }

    public static String emptyIfBlank(String str) {
        return EzyStrings.isBlank((String)str) ? "" : str;
    }

    public static String toLowerDashCaseWithoutSpecialCharacters(String str) {
        return Strings.toLowerDashCaseWithoutSpecialCharacters(str, Predicates.alwaysTrue());
    }

    public static String toLowerDashCaseWithoutSpecialCharacters(String str, Predicate<Character> characterFilter) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '-' || ch == ' ' || ch == '\t' || ch == '\n' || ch == '\u2013') {
                char prevCh;
                int builderLength = builder.length();
                char c = prevCh = builderLength > 0 ? builder.charAt(builderLength - 1) : (char)'\u0000';
                if (prevCh == '-') continue;
                builder.append('-');
                continue;
            }
            if (SPECIAL_CHARACTERS.indexOf(ch) >= 0 || !characterFilter.test(Character.valueOf(ch))) continue;
            builder.append(Character.toLowerCase(ch));
        }
        return builder.toString();
    }

    public static boolean isInteger(String str) {
        if (EzyStrings.isBlank((String)str)) {
            return false;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (!(i == 0 && str.charAt(i) == '-' ? str.length() == 1 : !Character.isDigit(str.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isBigDecimal(String str) {
        if (EzyStrings.isBlank((String)str)) {
            return false;
        }
        int i = 0;
        int length = str.length();
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            ++i;
        }
        boolean hasDecimalPoint = false;
        boolean hasDigit = false;
        while (i < length) {
            char ch = str.charAt(i);
            if (ch == '.') {
                if (hasDecimalPoint) {
                    return false;
                }
                hasDecimalPoint = true;
            } else if (Character.isDigit(ch)) {
                hasDigit = true;
            } else {
                return false;
            }
            ++i;
        }
        return hasDigit;
    }

    public static BigInteger toBigIntegerOrZero(String str) {
        try {
            return Strings.isInteger(str) ? new BigInteger(str) : BigInteger.ZERO;
        }
        catch (Exception e) {
            return BigInteger.ZERO;
        }
    }

    public static BigDecimal toBigDecimalOrZero(String str) {
        try {
            return Strings.isBigDecimal(str) ? new BigDecimal(str) : BigDecimal.ZERO;
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public static String firstNotBlankValue(String ... strs) {
        for (String str : strs) {
            if (!EzyStrings.isNotBlank((String)str)) continue;
            return str;
        }
        return null;
    }

    public static String fromTemplateAndParameters(String template, Map<String, Object> parameters) {
        char ch;
        StringBuilder builder = new StringBuilder();
        int length = template.length();
        int i = 0;
        block0: while (i < length) {
            char nextCh;
            ch = template.charAt(i);
            char c = nextCh = i < length - 1 ? template.charAt(i + 1) : (char)'\u0000';
            if ((ch == '$' || ch == '{') && nextCh == '{') {
                String varName = null;
                StringBuilder varNameBuilder = new StringBuilder();
                int k = i + 2;
                while (true) {
                    char nextChK;
                    if (k > length - 1) {
                        builder.append(ch).append(nextCh);
                        i = k;
                        break;
                    }
                    char chK = template.charAt(k);
                    char c2 = nextChK = k < length - 1 ? template.charAt(k + 1) : (char)'\u0000';
                    if (ch == '$' && chK == '}') {
                        varName = varNameBuilder.toString();
                        i = k + 1;
                        break;
                    }
                    if (ch == '{' && chK == '}' && nextChK == '}') {
                        i = k + 2;
                        varName = varNameBuilder.toString();
                        break;
                    }
                    varNameBuilder.append(chK);
                    ++k;
                }
                if (varName == null) {
                    builder.append((CharSequence)varNameBuilder);
                    continue;
                }
                String value = Strings.setDateTimeToVariableIfNeed(varName, parameters);
                if (EzyStrings.isBlank((String)value)) {
                    value = Strings.translateEmptyCheckTernaryOperatorIfNeed(varName, parameters);
                }
                if (value.isEmpty()) {
                    if (builder.length() <= 0 || (ch = builder.charAt(builder.length() - 1)) != ' ' && ch != '\t') continue;
                    while (i < length && ((ch = template.charAt(i)) == ' ' || ch == '\t')) {
                        ++i;
                    }
                    continue;
                }
                builder.append(value);
                continue;
            }
            if (ch == ' ' || ch == '\t') {
                char store = ch;
                ++i;
                while (i < length) {
                    ch = template.charAt(i);
                    if (ch != ' ' && ch != '\t') {
                        builder.append(store);
                        continue block0;
                    }
                    ++i;
                }
                continue;
            }
            builder.append(ch);
            ++i;
        }
        for (i = 0; i < builder.length(); ++i) {
            ch = builder.charAt(i);
            if (ch == ' ' || ch == '\t') continue;
            if (i <= 0) break;
            builder.delete(0, i);
            break;
        }
        int builderLength = builder.length();
        for (int i2 = builderLength - 1; i2 >= 0; --i2) {
            char ch2 = builder.charAt(i2);
            if (ch2 != ' ' && ch2 != '\t') {
                if (i2 >= builderLength - 1) break;
                builder.delete(i2 + 1, builderLength);
                break;
            }
            if (i2 != 0) continue;
            builder.delete(0, builderLength);
        }
        return builder.toString();
    }

    public static String toDateOrTimeOrDateTimeString(Object value, String format) {
        if (EzyStrings.isBlank((String)format)) {
            return value.toString();
        }
        if (value instanceof LocalDate) {
            return EzyDates.format((TemporalAccessor)((LocalDate)value), (String)format);
        }
        if (value instanceof LocalTime) {
            return EzyDates.format((TemporalAccessor)((LocalTime)value), (String)format);
        }
        if (value instanceof LocalDateTime) {
            return EzyDates.format((TemporalAccessor)((LocalDateTime)value), (String)format);
        }
        if (value instanceof Long) {
            return EzyDates.format((long)((Long)value), (String)format);
        }
        if (value instanceof Instant) {
            return EzyDates.format((long)((Instant)value).toEpochMilli(), (String)format);
        }
        return value.toString();
    }

    public static String setDateTimeToVariableIfNeed(String variableName, Map<String, Object> parameters) {
        if (variableName == null || parameters == null) {
            return "";
        }
        String[] strs = variableName.split("\\|\\|");
        String actualVariableName = strs[0];
        Object value = parameters.get(actualVariableName);
        if (value == null) {
            value = "";
        }
        String type = strs.length > 1 ? strs[1] : null;
        String format = strs.length > 2 ? strs[2] : null;
        String answer = "Date".equalsIgnoreCase(type) || "Time".equalsIgnoreCase(type) || "DateTime".equalsIgnoreCase(type) ? Strings.toDateOrTimeOrDateTimeString(value, format) : Strings.from(value).trim();
        return answer;
    }

    public static String translateEmptyCheckTernaryOperatorIfNeed(String expression, Map<String, Object> parameters) {
        if (EzyStrings.isBlank((String)expression)) {
            return "";
        }
        int questionIndex = expression.indexOf(63);
        int colonIndex = expression.indexOf(58);
        int length = expression.length();
        if (questionIndex <= 0 || colonIndex <= questionIndex || colonIndex >= length - 1) {
            return "";
        }
        String variable = expression.substring(0, questionIndex).trim();
        String value = Strings.from(parameters.get(variable));
        if (EzyStrings.isBlank((String)value)) {
            String falseVariable = expression.substring(colonIndex + 1, length).trim();
            return Strings.from(parameters.getOrDefault(falseVariable, falseVariable));
        }
        String trueVariable = expression.substring(questionIndex + 1, colonIndex).trim();
        return Strings.from(parameters.getOrDefault(trueVariable, trueVariable));
    }

    public static int indexOfTextInStringIgnoreCase(String message, String keyword) {
        return Strings.indexOfTextInStringIgnoreCase(message, keyword, 0);
    }

    public static int indexOfTextInStringIgnoreCase(String message, String keyword, int startIndex) {
        int index = message.indexOf(keyword, startIndex);
        if (index < 0) {
            index = message.indexOf(keyword.toUpperCase(), startIndex);
        }
        return index;
    }
}

