/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.concurrent;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class EzyThreadFactory
extends EzyLoggable
implements ThreadFactory {
    protected int priority;
    protected String prefix;
    protected boolean daemon;
    protected String poolName;
    protected String threadPrefix;
    protected ThreadGroup threadGroup;
    protected AtomicInteger threadCounter = new AtomicInteger();
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger();

    protected EzyThreadFactory(Builder builder) {
        int poolId = POOL_COUNTER.incrementAndGet();
        this.prefix = builder.prefix;
        this.daemon = builder.daemon;
        this.priority = builder.priority;
        this.poolName = builder.getPoolName();
        this.threadGroup = builder.threadGroup;
        this.poolName = this.getFullPoolName();
        this.threadPrefix = this.poolName + '-' + poolId + '-';
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Thread newThread(Runnable runnable) {
        Thread thread = this.createThread(runnable, this.getThreadName());
        this.setUpThread(thread);
        return thread;
    }

    protected Thread createThread(Runnable runnable, String name) {
        return new Thread(runnable, name);
    }

    protected void setUpThread(Thread thread) {
        try {
            this.trySetUpThread(thread);
        }
        catch (Exception e) {
            this.logger.warn("can not setup thread {}", (Object)thread.getName(), (Object)e);
        }
    }

    protected void trySetUpThread(Thread thread) {
        if (thread.isDaemon()) {
            if (!this.daemon) {
                thread.setDaemon(false);
            }
        } else if (this.daemon) {
            thread.setDaemon(true);
        }
        if (thread.getPriority() != this.priority) {
            thread.setPriority(this.priority);
        }
    }

    protected String getThreadName() {
        return this.threadPrefix + this.threadCounter.incrementAndGet();
    }

    protected String getFullPoolName() {
        return EzyStrings.isNoContent((String)this.prefix) ? this.poolName : this.prefix + "-" + this.poolName;
    }

    public static class Builder
    implements EzyBuilder<EzyThreadFactory> {
        protected int priority = 5;
        protected String prefix = "ezyfox";
        protected boolean daemon = false;
        protected String poolName = "";
        protected ThreadGroup threadGroup = this.getSystemThreadGroup();

        public Builder priority(int priority) {
            this.validatePriority(priority);
            this.priority = priority;
            return this;
        }

        public Builder daemon(boolean daemon) {
            this.daemon = daemon;
            return this;
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public Builder poolName(String poolName) {
            this.poolName = poolName;
            return this;
        }

        public Builder poolName(Class poolType) {
            this.poolName = poolType.getSimpleName();
            return this;
        }

        public Builder threadGroup(ThreadGroup threadGroup) {
            this.threadGroup = threadGroup;
            return this;
        }

        protected String getPoolName() {
            return this.poolName == null ? "" : this.poolName.toLowerCase();
        }

        public EzyThreadFactory build() {
            return new EzyThreadFactory(this);
        }

        protected void validatePriority(int priority) {
            if (priority < 1 || priority > 10) {
                throw new IllegalArgumentException("priority: " + priority + " (expected: Thread.MIN_PRIORITY <= priority <= Thread.MAX_PRIORITY)");
            }
        }

        protected ThreadGroup getSystemThreadGroup() {
            return this.getSecurityManager() == null ? Thread.currentThread().getThreadGroup() : this.getSecurityManager().getThreadGroup();
        }

        protected SecurityManager getSecurityManager() {
            return System.getSecurityManager();
        }
    }
}

