/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.client.request;

import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestEntity;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractRequest<R extends AbstractRequest<R>>
implements Request {
    protected String url;
    protected int readTimeout;
    protected int connectTimeout;
    protected RequestEntity entity;
    protected final Map<Integer, Class<?>> responseTypes = new HashMap();

    @Override
    public String getURL() {
        return this.url;
    }

    public R setURL(URI uri) {
        this.url = uri.toString();
        return (R)this;
    }

    public R setURL(URL url) {
        this.url = url.toString();
        return (R)this;
    }

    public R setURL(String url) {
        this.url = url;
        return (R)this;
    }

    public R setEntity(RequestEntity entity) {
        this.entity = entity;
        return (R)this;
    }

    public R setEntity(Object requestBody) {
        return this.setEntity(RequestEntity.body(requestBody));
    }

    public R setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return (R)this;
    }

    public R setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return (R)this;
    }

    public R setResponseType(Class<?> responseType) {
        return this.setResponseType(200, responseType);
    }

    public R setResponseType(int statusCode, Class<?> responseType) {
        this.responseTypes.put(statusCode, responseType);
        return (R)this;
    }

    @Override
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public RequestEntity getEntity() {
        return this.entity;
    }

    @Override
    public Map<Integer, Class<?>> getResponseTypes() {
        return this.responseTypes;
    }
}

