/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.security;

import com.tvd12.ezyfox.file.EzyFileWriter;
import com.tvd12.ezyfox.security.EzyKeysGenerator;
import java.io.File;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;

public class EzyFileKeysGenerator
extends EzyKeysGenerator {
    protected File publicKeyFile;
    protected File privateKeyFile;
    protected EzyFileWriter fileWriter;

    protected EzyFileKeysGenerator(Builder builder) {
        super(builder);
        this.fileWriter = builder.fileWriter;
        this.publicKeyFile = builder.publicKeyFile;
        this.privateKeyFile = builder.privateKeyFile;
    }

    @Override
    public KeyPair generate() {
        KeyPair keyPair = super.generate();
        this.writePublicKey(keyPair.getPublic());
        this.writePrivateKey(keyPair.getPrivate());
        return keyPair;
    }

    protected void writePublicKey(PublicKey key) {
        this.writeKey(this.publicKeyFile, key);
    }

    protected void writePrivateKey(PrivateKey key) {
        this.writeKey(this.privateKeyFile, key);
    }

    protected void writeKey(File file, Key key) {
        if (file != null) {
            this.fileWriter.write(file, key.getEncoded());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends EzyKeysGenerator.Builder<Builder> {
        protected File publicKeyFile;
        protected File privateKeyFile;
        protected EzyFileWriter fileWriter;

        public Builder fileWriter(EzyFileWriter fileWriter) {
            this.fileWriter = fileWriter;
            return this;
        }

        public Builder publicKeyFile(File file) {
            this.publicKeyFile = file;
            return this;
        }

        public Builder privateKeyFile(File file) {
            this.privateKeyFile = file;
            return this;
        }

        @Override
        public EzyFileKeysGenerator build() {
            return new EzyFileKeysGenerator(this);
        }
    }
}

