/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.cli;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyPair;
import java.io.Console;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.youngmonkeys.ezyplatform.cli.Command;
import org.youngmonkeys.ezyplatform.cli.Setup;
import org.youngmonkeys.ezyplatform.cli.arguments.Arguments;
import org.youngmonkeys.ezyplatform.cli.arguments.ArgumentsReader;
import org.youngmonkeys.ezyplatform.cli.handler.ActivateModuleCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.CommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.ConsoleCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.DeactivateModuleCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.HelpCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.ListCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.RemoveModuleCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.RestartCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.StartCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.StopCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.TablesCommandHandler;
import org.youngmonkeys.ezyplatform.cli.handler.TestCommandHandler;
import org.youngmonkeys.ezyplatform.cli.util.BannerPrinter;

public final class CLI {
    private final Setup setup = new Setup();
    private final Scanner scanner = new Scanner(System.in);
    private final ArgumentsReader argumentsReader = new ArgumentsReader();
    private final Map<Command, CommandHandler> handlers = this.defaultHandlers();

    private CLI() {
    }

    private void run(String[] args) {
        if (args.length > 0) {
            this.runOneTime(args);
        } else if (this.setup.run()) {
            this.runByLoop();
        }
        this.writeToHistory("done");
    }

    private void runOneTime(String[] args) {
        try {
            this.writeToHistory("run: " + String.join((CharSequence)" ", args));
            Map<String, String> arguments = this.argumentsReader.read(args);
            String line = arguments.get("-c");
            this.runCommandLine(line, true);
            this.writeToHistory("finish: " + String.join((CharSequence)" ", args));
        }
        catch (IllegalArgumentException e) {
            this.error(e.getMessage());
            this.writeToHistory(e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeToHistory(e);
        }
    }

    private void runByLoop() {
        String line;
        Console console = System.console();
        System.out.println(new BannerPrinter().getBannerText());
        System.out.println("Welcome to ezyplatform CLI, type 'help' command to get a help >\n");
        do {
            System.out.print("cli$: ");
        } while (this.runCommandLine(line = console != null ? console.readLine() : this.scanner.nextLine(), false));
    }

    private boolean runCommandLine(String line, boolean oneTime) {
        EzyPair<Command, String> pair = this.parseLine(line);
        if (pair != null) {
            Command command = (Command)((Object)pair.getKey());
            if (oneTime && command.isSetupRequired() && !this.setup.run()) {
                return false;
            }
            if (command == Command.EXIT || command == Command.QUIT) {
                this.printlnByte();
                return false;
            }
            CommandHandler handler = this.handlers.get((Object)command);
            try {
                Arguments arguments = handler.parse((String)pair.getValue());
                handler.handle(arguments);
            }
            catch (IllegalArgumentException e) {
                this.error(e.getMessage());
                this.writeToHistory(e.getMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeToHistory(e);
            }
        }
        return true;
    }

    private void printlnByte() {
        System.out.println("Bye");
    }

    private void error(String msg) {
        System.err.println(msg);
    }

    private EzyPair<Command, String> parseLine(String line) {
        String commandName;
        if (EzyStrings.isNoContent((String)line)) {
            return null;
        }
        String string = line.trim().replace('\t', ' ').replace("  ", " ");
        int firstSpaceIndex = string.indexOf(32);
        String argumentString = "";
        if (firstSpaceIndex < 0) {
            commandName = string;
        } else {
            commandName = string.substring(0, firstSpaceIndex);
            argumentString = string.substring(firstSpaceIndex + 1).trim();
        }
        Command command = Command.of(commandName);
        if (command != null) {
            return new EzyPair((Object)command, (Object)argumentString);
        }
        for (Command cmd : Command.values()) {
            if (!cmd.getName().contains(commandName.toLowerCase())) continue;
            System.out.println("Command: '" + commandName + "' not found, do you mean: " + cmd.getName() + "?");
            return null;
        }
        System.out.println("Command: '" + commandName + "' not found, run 'help' to get the command list");
        return null;
    }

    public static void main(String[] args) {
        new CLI().run(args);
    }

    private Map<Command, CommandHandler> defaultHandlers() {
        HashMap<Command, CommandHandler> map = new HashMap<Command, CommandHandler>();
        map.put(Command.HELP, new HelpCommandHandler());
        map.put(Command.HELP_1, new HelpCommandHandler());
        map.put(Command.LIST, new ListCommandHandler());
        map.put(Command.LIST_1, new ListCommandHandler());
        map.put(Command.CONSOLE, new ConsoleCommandHandler());
        map.put(Command.START, new StartCommandHandler());
        map.put(Command.STOP, new StopCommandHandler());
        map.put(Command.RESTART, new RestartCommandHandler());
        map.put(Command.ACTIVATE, new ActivateModuleCommandHandler());
        map.put(Command.DEACTIVATE, new DeactivateModuleCommandHandler());
        map.put(Command.REMOVE, new RemoveModuleCommandHandler());
        map.put(Command.TABLES, new TablesCommandHandler());
        map.put(Command.TEST, new TestCommandHandler());
        return map;
    }

    private void writeToHistory(Throwable exception) {
        this.writeToHistory(exception.getClass().getName() + "(" + exception.getMessage() + ")");
    }

    private void writeToHistory(String message) {
        Path logsFolder = Paths.get("logs", new String[0]);
        Path historyFile = Paths.get(logsFolder.toString(), "cli-history.txt");
        try {
            if (!Files.exists(logsFolder, new LinkOption[0])) {
                Files.createDirectory(logsFolder, new FileAttribute[0]);
            }
            if (!Files.exists(historyFile, new LinkOption[0])) {
                Files.createFile(historyFile, new FileAttribute[0]);
            }
            String line = LocalDateTime.now() + ": " + message;
            Files.write(historyFile, Collections.singletonList(line), StandardOpenOption.APPEND);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not write history to " + historyFile + ", please check your permission");
        }
    }
}

