/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;

public class EzyGetterBuilder
extends EzyLoggable
implements EzyBuilder<Function> {
    protected static final AtomicInteger COUNT = new AtomicInteger(0);
    protected static boolean debug;
    protected EzyField field;
    protected EzyMethod method;
    protected Class<?> declaringClass;

    public EzyGetterBuilder field(EzyField field) {
        this.field = field;
        this.declaringClass = field.getField().getDeclaringClass();
        return this;
    }

    public EzyGetterBuilder method(EzyMethod method) {
        this.method = method;
        this.declaringClass = method.getMethod().getDeclaringClass();
        return this;
    }

    @Override
    public Function build() {
        try {
            return this.doBuild();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("build getter: " + this.field + " error", e);
        }
    }

    protected Function doBuild() throws Exception {
        String implClassName = this.getImplClassName();
        ClassPool pool = ClassPool.getDefault();
        CtClass implClass = pool.makeClass(implClassName);
        String acceptMethodContent = this.makeApplyMethodContent();
        this.printMethodContent(acceptMethodContent);
        implClass.addMethod(CtNewMethod.make((String)acceptMethodContent, (CtClass)implClass));
        implClass.setInterfaces(new CtClass[]{pool.get(Function.class.getName())});
        Class answerClass = implClass.toClass();
        implClass.detach();
        return (Function)EzyClasses.newInstance(answerClass);
    }

    protected String makeApplyMethodContent() {
        String methodName;
        Class type;
        if (this.field != null) {
            type = this.field.getType();
            methodName = this.field.getGetterMethod();
        } else {
            type = this.method.getReturnType();
            methodName = this.method.getName();
        }
        return new EzyFunction(this.getEntityTypeMethod()).body().append(new EzyInstruction("\t", "\n").append(type.getTypeName()).append(" answer = ").cast(this.declaringClass, "arg0").dot().append(methodName).bracketopen().bracketclose()).append(new EzyInstruction("\t", "\n").answer().valueOf(type, "answer")).function().toString();
    }

    protected EzyMethod getEntityTypeMethod() {
        Method method = EzyMethods.getMethod(Function.class, "apply", Object.class);
        return new EzyMethod(method);
    }

    protected String getImplClassName() {
        String name = this.field != null ? this.field.getName() : this.method.getFieldName();
        return this.declaringClass.getName() + "$" + name + "$EzyObjectProxy$GetterImpl$" + COUNT.incrementAndGet();
    }

    protected void printMethodContent(String methodContent) {
        if (debug) {
            this.logger.info("method content \n{}", (Object)methodContent);
        }
    }

    public static void setDebug(boolean debug) {
        EzyGetterBuilder.debug = debug;
    }
}

