/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.reflect;

import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyGetterBuilder;
import com.tvd12.ezyfox.reflect.EzyObjectProxy;
import com.tvd12.ezyfox.reflect.EzySetterBuilder;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class EzyObjectProxyProvider {
    protected final Map<Class, EzyObjectProxy> objectProxies = new ConcurrentHashMap<Class, EzyObjectProxy>();

    public EzyObjectProxy getObjectProxy(Class<?> objectType) {
        return this.objectProxies.computeIfAbsent(objectType, this::newObjectProxy);
    }

    protected EzyObjectProxy newObjectProxy(Class<?> objectType) {
        EzyClass clazz = new EzyClass(objectType);
        Collection<EzyField> fields = this.getFields(clazz);
        HashMap<String, Function<Object, Object>> getters = new HashMap<String, Function<Object, Object>>();
        HashMap<String, BiConsumer<Object, Object>> setters = new HashMap<String, BiConsumer<Object, Object>>();
        HashMap propertyTypes = new HashMap();
        for (EzyField field : fields) {
            getters.put(field.getName(), this.newGetter(field));
            setters.put(field.getName(), this.newSetter(field));
            propertyTypes.put(field.getName(), field.getType());
        }
        Map<String, String> fieldKeys = this.getFieldKeys(fields);
        EzyObjectProxy.Builder builder = this.newObjectProxyBuilder(clazz).propertyKey(fieldKeys).addSetters(setters).addGetters(getters).addPropertyTypes(propertyTypes);
        this.preBuildObjectProxy(clazz, builder);
        return builder.build();
    }

    protected void preBuildObjectProxy(EzyClass clazz, EzyObjectProxy.Builder builder) {
    }

    protected Collection<EzyField> getFields(EzyClass clazz) {
        return clazz.getFields((EzyField f) -> this.isSettableField((EzyField)f));
    }

    protected boolean isSettableField(EzyField field) {
        return field.isWritable() && !Modifier.isStatic(field.getField().getModifiers());
    }

    protected Function newGetter(EzyField field) {
        return new EzyGetterBuilder().field(field).build();
    }

    protected BiConsumer newSetter(EzyField field) {
        return new EzySetterBuilder().field(field).build();
    }

    protected EzyObjectProxy.Builder newObjectProxyBuilder(EzyClass clazz) {
        return EzyObjectProxy.builder();
    }

    protected Map<String, String> getFieldKeys(Collection<EzyField> fields) {
        return Collections.emptyMap();
    }
}

