/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.model;

import java.util.Collections;
import java.util.Map;

public class CommonEntityModel {
    private long id;
    private String name;
    private String displayName;
    private String url;
    private Map<String, Object> properties;

    public static CommonEntityModel defaultEntity(long id, String name) {
        return CommonEntityModel.builder().id(id).name(name).build();
    }

    public Map<String, Object> getProperties() {
        return this.properties != null ? this.properties : Collections.emptyMap();
    }

    CommonEntityModel(long id, String name, String displayName, String url, Map<String, Object> properties) {
        this.id = id;
        this.name = name;
        this.displayName = displayName;
        this.url = url;
        this.properties = properties;
    }

    public static CommonEntityModelBuilder builder() {
        return new CommonEntityModelBuilder();
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getUrl() {
        return this.url;
    }

    public static class CommonEntityModelBuilder {
        private long id;
        private String name;
        private String displayName;
        private String url;
        private Map<String, Object> properties;

        CommonEntityModelBuilder() {
        }

        public CommonEntityModelBuilder id(long id) {
            this.id = id;
            return this;
        }

        public CommonEntityModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public CommonEntityModelBuilder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public CommonEntityModelBuilder url(String url) {
            this.url = url;
            return this;
        }

        public CommonEntityModelBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public CommonEntityModel build() {
            return new CommonEntityModel(this.id, this.name, this.displayName, this.url, this.properties);
        }

        public String toString() {
            return "CommonEntityModel.CommonEntityModelBuilder(id=" + this.id + ", name=" + this.name + ", displayName=" + this.displayName + ", url=" + this.url + ", properties=" + this.properties + ")";
        }
    }
}

