/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.converter.DefaultEntityToModelConverter;
import org.youngmonkeys.ezyplatform.converter.DefaultModelToEntityConverter;
import org.youngmonkeys.ezyplatform.entity.UniqueData;
import org.youngmonkeys.ezyplatform.entity.UniqueDataId;
import org.youngmonkeys.ezyplatform.model.UniqueDataKeyValueModel;
import org.youngmonkeys.ezyplatform.model.UniqueDataModel;
import org.youngmonkeys.ezyplatform.repo.UniqueDataRepository;
import org.youngmonkeys.ezyplatform.service.UniqueDataService;

public class DefaultUniqueDataService
implements UniqueDataService {
    private final UniqueDataRepository uniqueDataRepository;
    private final DefaultEntityToModelConverter entityToModelConverter;
    private final DefaultModelToEntityConverter modelToEntityConverter;

    @Override
    public void saveDataMeta(UniqueDataModel model) {
        this.uniqueDataRepository.save(this.modelToEntityConverter.toEntity(model));
    }

    @Override
    public void saveDataMetaList(List<UniqueDataModel> models) {
        List entities = EzyLists.newArrayList(models, this.modelToEntityConverter::toEntity);
        this.uniqueDataRepository.save(entities);
    }

    @Override
    public void saveDataMetaList(String dataType, long dataId, List<UniqueDataKeyValueModel> models) {
        List entities = EzyLists.newArrayList(models, it -> this.modelToEntityConverter.toEntity(dataType, dataId, (UniqueDataKeyValueModel)it));
        this.uniqueDataRepository.save(entities);
    }

    @Override
    public UniqueDataModel getUniqueDataByDataTypeAndDataIdAndUniqueKey(String dataType, long dataId, String uniqueKey) {
        return this.entityToModelConverter.toModel((UniqueData)this.uniqueDataRepository.findById(new UniqueDataId(dataType, dataId, uniqueKey)));
    }

    @Override
    public Map<Long, UniqueDataModel> getUniqueDataMapByDataTypeAndDataIdsAndUniqueKey(String dataType, Collection<Long> dataIds, String uniqueKey) {
        if (dataIds.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.uniqueDataRepository.findByDataTypeAndDataIdInAndUniqueKey(dataType, dataIds, uniqueKey).stream().collect(Collectors.toMap(UniqueData::getDataId, this.entityToModelConverter::toModel));
    }

    @Override
    public Map<Long, Map<String, UniqueDataModel>> getUniqueDataMapsByDataTypeAndDataIdsAndUniqueKeys(String dataType, Collection<Long> dataIds, Collection<String> uniqueKeys) {
        if (dataIds.isEmpty() || uniqueKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        return this.uniqueDataRepository.findByDataTypeAndDataIdInAndUniqueKeyIn(dataType, dataIds, uniqueKeys).stream().collect(Collectors.groupingBy(UniqueData::getDataId, Collectors.toMap(UniqueData::getUniqueKey, this.entityToModelConverter::toModel)));
    }

    public DefaultUniqueDataService(UniqueDataRepository uniqueDataRepository, DefaultEntityToModelConverter entityToModelConverter, DefaultModelToEntityConverter modelToEntityConverter) {
        this.uniqueDataRepository = uniqueDataRepository;
        this.entityToModelConverter = entityToModelConverter;
        this.modelToEntityConverter = modelToEntityConverter;
    }
}

