/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.service;

import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyEntry;
import com.tvd12.reflections.util.Predicates;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.model.UserMetaModel;
import org.youngmonkeys.ezyplatform.util.Strings;

public interface UserMetaService {
    public void saveUserMeta(long var1, String var3, String var4);

    default public void saveUserMeta(long userId, String metaKey, Object metaValue) {
        this.saveUserMeta(userId, metaKey, Strings.from(metaValue));
    }

    public void saveUserMeta(long var1, String var3, List<String> var4);

    default public void saveUserMeta(long userId, String metaKey, Collection<Object> metaValues) {
        this.saveUserMeta(userId, metaKey, EzyLists.newArrayList(metaValues, Strings::from));
    }

    default public void saveUserMetaIfAbsent(long userId, String metaKey, Object metaValue) {
        this.saveUserMetaIfAbsent(userId, metaKey, Strings.from(metaValue));
    }

    public void saveUserMetaIfAbsent(long var1, String var3, String var4);

    default public void saveUserMetaIfAbsent(long userId, String metaKey, List<String> metaValues) {
        metaValues.parallelStream().forEach(metaValue -> this.saveUserMetaIfAbsent(userId, metaKey, (String)metaValue));
    }

    default public void saveUserMetaIfAbsent(long userId, String metaKey, Collection<Object> metaValues) {
        metaValues.parallelStream().filter(Objects::nonNull).forEach(metaValue -> this.saveUserMetaIfAbsent(userId, metaKey, metaValue));
    }

    default public void saveUserMetaUniqueKey(long userId, String metaKey, Object metaValue) {
        this.saveUserMetaUniqueKey(userId, metaKey, Strings.from(metaValue));
    }

    default public void saveUserMetaUniqueKey(long userId, String metaKey, String metaValue) {
        this.saveUserMetaUniqueKey(userId, metaKey, metaValue, null);
    }

    public void saveUserMetaUniqueKey(long var1, String var3, String var4, String var5);

    default public void saveUserMetaUniqueKeys(long userId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveUserMetaUniqueKey(userId, (String)e.getKey(), e.getValue()));
    }

    default public void saveUserMetaTextValueUniqueKeys(long userId, Map<String, Object> valueMap) {
        valueMap.entrySet().parallelStream().filter(e -> e.getValue() != null).forEach(e -> this.saveUserMetaUniqueKey(userId, (String)e.getKey(), "", Strings.from(e.getValue())));
    }

    public BigDecimal increaseUserMetaValue(long var1, String var3, BigDecimal var4);

    default public BigInteger increaseUserMetaValue(long userId, String metaKey, BigInteger value) {
        return this.increaseUserMetaValue(userId, metaKey, new BigDecimal(value)).toBigInteger();
    }

    public void deleteUserMetaById(long var1);

    public void deleteUserMetaByUserId(long var1);

    public void deleteUserMetaByUserIds(Collection<Long> var1);

    public boolean containsUserMeta(long var1, String var3, String var4);

    public long getUserIdByMeta(String var1, String var2);

    default public long getUserIdByMeta(String metaKey, Object metaValue) {
        return this.getUserIdByMeta(metaKey, Strings.from(metaValue));
    }

    public String getMetaValueByUserIdAndMetaKey(long var1, String var3);

    public String getLatestMetaValueByUserIdAndMetaKey(long var1, String var3);

    default public String getMetaValueByUserIdAndMetaKeyOrDefault(long userId, String metaKey, String defaultValue) {
        String value = this.getMetaValueByUserIdAndMetaKey(userId, metaKey);
        return value != null ? value : defaultValue;
    }

    public String getMetaTextValueByUserIdAndMetaKey(long var1, String var3);

    public String getLatestMetaTextValueByUserIdAndMetaKey(long var1, String var3);

    default public String getMetaTextValueByUserIdAndMetaKeyOrDefault(long userId, String metaKey, String defaultValue) {
        String value = this.getMetaTextValueByUserIdAndMetaKey(userId, metaKey);
        return value != null ? value : defaultValue;
    }

    default public BigDecimal getMetaDecimalValueByUserIdAndMetaKey(long userId, String metaKey) {
        String value = this.getMetaValueByUserIdAndMetaKey(userId, metaKey);
        return value != null ? new BigDecimal(value) : BigDecimal.ZERO;
    }

    default public BigInteger getMetaIntegerValueByUserIdAndMetaKey(long userId, String metaKey) {
        String value = this.getMetaValueByUserIdAndMetaKey(userId, metaKey);
        return value != null ? new BigInteger(value) : BigInteger.ZERO;
    }

    public List<String> getMetaValuesByUserIdAndMetaKey(long var1, String var3, int var4);

    default public <T> List<T> getMetaValuesByUserIdAndMetaKey(long userId, String metaKey, int limit, Function<String, T> valueConverter) {
        return EzyLists.newArrayList(this.getMetaValuesByUserIdAndMetaKey(userId, metaKey, limit), valueConverter);
    }

    public Map<String, String> getUserMetaValues(long var1);

    public Map<String, String> getUserMetaTextValues(long var1);

    public Map<String, Long> getUserIdMapByMetaValues(String var1, Collection<String> var2);

    public Map<Long, String> getUserMetaValueMapByUserIds(Collection<Long> var1, String var2);

    default public <T> Map<Long, T> getUserMetaValueMapByUserIds(Collection<Long> userIds, String metaKey, Function<String, T> valueConverter) {
        return this.getUserMetaValueMapByUserIds(userIds, metaKey, Predicates.alwaysTrue(), valueConverter);
    }

    default public <T> Map<Long, T> getUserMetaValueMapByUserIds(Collection<Long> userIds, String metaKey, Predicate<String> valueFilter, Function<String, T> valueConverter) {
        return this.getUserMetaValueMapByUserIds(userIds, metaKey).entrySet().stream().filter(e -> e.getValue() != null).filter(e -> valueFilter.test((String)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, e -> valueConverter.apply((String)e.getValue())));
    }

    public Map<String, String> getUserMetaValueMapByUserIdAndMetaKeys(long var1, Collection<String> var3);

    default public Map<String, String> getLatestMetaValueMapByUserIdAndMetaKeys(long userId, Collection<String> metaKeys) {
        return metaKeys.parallelStream().map(it -> EzyEntry.of((Object)it, (Object)this.getLatestMetaValueByUserIdAndMetaKey(userId, (String)it))).filter(it -> it.getValue() != null).collect(Collectors.toMap(EzyEntry::getKey, EzyEntry::getValue));
    }

    public Map<Long, String> getUserMetaTextValueMapByUserIds(Collection<Long> var1, String var2);

    default public Map<Long, BigDecimal> getUserMetaBigDecimalValueMapByUserIds(Collection<Long> userIds, String metaKey) {
        return this.getUserMetaValueMapByUserIds(userIds, metaKey, EzyStrings::isNotBlank, BigDecimal::new);
    }

    default public Map<Long, BigInteger> getUserMetaBigIntegerValueMapByUserIds(Collection<Long> userIds, String metaKey) {
        return this.getUserMetaValueMapByUserIds(userIds, metaKey, EzyStrings::isNotBlank, BigInteger::new);
    }

    public List<UserMetaModel> getMetaListByUserIdAndMetaKeys(long var1, Collection<String> var3);
}

