/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.constant;

import com.tvd12.ezyfox.util.EzyEnums;
import java.util.Map;

public enum ContentType {
    AAC_AUDIO("audio/aac", "aac"),
    ABI_WORD_DOCUMENT("application/x-abiword", "abw"),
    ARCHIVE_DOCUMENT("application/x-freearc", "arc"),
    AUDIO_VIDEO_INTERLEAVE("video/x-msvideo", "avi"),
    AMAZON_KINDLE_EBOOK("application/vnd.amazon.ebook", "azw"),
    BZIP("application/x-bzip", "bz"),
    BZIP2("application/x-bzip2", "bz2"),
    CD_AUDIO("application/x-cdf", "cda"),
    CSHELL_SCRIPT("application/x-csh", "csh"),
    TEXT_CSV("text/csv", "csv"),
    MICROSOFT_WORD("application/msword", "doc"),
    MICROSOFT_WORD_X("application/vnd.openxmlformats-officedocument.wordprocessingml.document", "docx"),
    MS_EMBEDDED_OPENTYPE_FONTS("application/vnd.ms-fontobject", "eot"),
    EPUB("application/epub+zip", "epub"),
    GZIP("application/gzip", "gz"),
    ICON("image/vnd.microsoft.icon", "ico"),
    ICALENDAR("text/calendar", "ics"),
    JAR("application/java-archive", "jar"),
    JSONLD("application/ld+json", "jsonld"),
    MUSICAL_INSTRUMENT_DIGITAL_INTERFACE("audio/midi", "mid"),
    MUSICAL_INSTRUMENT_DIGITAL_INTERFACE_X("audio/x-midi", "midi"),
    TEXT_JAVASCRIPT_MODULE("text/javascript", "mjs"),
    MP3("audio/mpeg", "mp3"),
    MP4("video/mp4", "mp4"),
    MPGEG("video/mpeg", "mpeg"),
    APPLE_INSTALLER_PACKAGE("application/vnd.apple.installer+xml", "mpkg"),
    OPEN_DOCUMENT_PRESENTATION("application/vnd.oasis.opendocument.presentation", "odp"),
    OPENDOCUMENT_SPREADSHEET("application/vnd.oasis.opendocument.spreadsheet", "ods"),
    OPENDOCUMENT_TEXT("application/vnd.oasis.opendocument.text", "odt"),
    OGG_AUDIO("audio/ogg", "oga"),
    OGG_VIDEO("video/ogg", "ogv"),
    OGG("application/ogg", "ogx"),
    OPUS_AUDIO("audio/opus", "opus"),
    PHP("application/x-httpd-php", "php"),
    MICROSOFT_POWERPOINT("application/vnd.ms-powerpoint", "ppt"),
    MICROSOFT_POWERPOINT_X("application/vnd.openxmlformats-officedocument.presentationml.presentation", "pptx"),
    RAR("application/vnd.rar", "rar"),
    RICH_TEXT_FORMAT("application/rtf", "rtf"),
    BOURNE_SHELL_SCRIPT("application/x-sh", "sh"),
    ADOBE_SMALL_WEB_FORMAT("application/x-shockwave-flash", "swf"),
    TAR("application/x-tar", "tar"),
    MPEG_TRANSPORT_STREAM("video/mp2t", "ts"),
    MICROSOFT_VISIO("application/vnd.visio", "vsd"),
    WAV("audio/wav", "wav"),
    WEBM_AUDIO("audio/webm", "weba"),
    WEBM_VIDEO("video/webm", "webm"),
    XHTML("application/xhtml+xml", "xhtml"),
    MICROSOFT_EXCEL("application/vnd.ms-excel", "xls"),
    MICROSOFT_EXCEL_X("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "xlsx"),
    APPLICATION_XML("application/xml", "xml"),
    APPLICATION_XUL("application/vnd.mozilla.xul+xml", "xul"),
    ZIP("application/zip", "zip"),
    THREE_GP_VIDEO("video/3gpp", "3gp"),
    THREE_GP_AUDIO("audio/3gpp", "3gp"),
    THREE_GP_VIDEO_2("video/3gpp2", "3g2"),
    THREE_GP_AUDIO_2("audio/3gpp2", "3g2"),
    SEVEN_ZIP("application/x-7z-compressed", "7z"),
    APPLICATION_PDF("application/pdf", "pdf"),
    APPLICATION_JSON("application/json", "json"),
    APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded", ""),
    APPLICATION_OCTET_STREAM("application/octet-stream", ""),
    APPLICATION_WASM("application/wasm", "wasm"),
    FONT_OTF("font/otf", "otf"),
    FONT_TTF("font/ttf", "ttf"),
    FONT_WOFF("font/woff", "woff"),
    FONT_WOFF2("font/woff2", "woff2"),
    IMAGE_BMP("image/bmp", "bmp"),
    IMAGE_JPEG("image/jpeg", "jpeg"),
    IMAGE_JPG("image/jpeg", "jpg"),
    IMAGE_GIF("image/gif", "gif"),
    IMAGE_PNG("image/png", "png"),
    IMAGE_SVG("image/svg+xml", "svg"),
    IMAGE_TIFF("image/tiff", "tiff"),
    IMAGE_TIF("image/tiff", "tif"),
    IMAGE_WEBP("image/webp", "webp"),
    TEXT_CSS("text/css", "css"),
    TEXT_JAVASCRIPT("text/javascript", "js"),
    TEXT_HTML("text/html", ""),
    TEXT_HTML_UTF8("text/html; charset=utf-8", "html"),
    TEXT_PLAIN("text/plain", "txt");

    private final String extension;
    private final String value;
    private static final Map<String, ContentType> VALUE_BY_MIME_TYPE;
    private static final Map<String, ContentType> VALUE_BY_EXTENSION;

    private ContentType(String value, String extension) {
        this.value = value;
        this.extension = extension;
    }

    public String getMimeType() {
        return this.value;
    }

    public static ContentType ofMimeType(String mimeType) {
        return VALUE_BY_MIME_TYPE.get(mimeType);
    }

    public static ContentType ofExtension(String extension) {
        return VALUE_BY_EXTENSION.getOrDefault(extension, APPLICATION_OCTET_STREAM);
    }

    public static String getExtensionOfMimeType(String mimeType, String defaultExtension) {
        ContentType contentType = VALUE_BY_MIME_TYPE.get(mimeType);
        if (contentType != null) {
            return contentType.getExtension();
        }
        return defaultExtension;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getValue() {
        return this.value;
    }

    static {
        VALUE_BY_MIME_TYPE = EzyEnums.enumMap(ContentType.class, it -> it.value);
        VALUE_BY_EXTENSION = EzyEnums.enumMap(ContentType.class, it -> it.extension);
    }
}

