/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.core.response;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyhttp.core.data.MultiValueMap;
import com.tvd12.ezyhttp.core.response.ResponseAsync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResponseEntity {
    protected final Object body;
    protected final int status;
    protected final MultiValueMap headers;
    public static final ResponseAsync ASYNC = ResponseAsync.getInstance();

    public ResponseEntity(int status, MultiValueMap headers, Object body) {
        this.body = body;
        this.status = status;
        this.headers = headers;
    }

    public ResponseEntity(int status, Map<String, List<String>> headers, Object body) {
        this(status, headers != null ? new MultiValueMap(headers) : null, body);
    }

    public static Builder status(int status) {
        return ResponseEntity.builder().status(status);
    }

    public static Builder of(int status, Object body) {
        return ResponseEntity.status(status).body(body);
    }

    public static ResponseEntity create(int status, Object body) {
        return new ResponseEntity(status, (MultiValueMap)null, body);
    }

    public static ResponseEntity ok() {
        return ResponseEntity.create(200, null);
    }

    public static ResponseEntity ok(Object body) {
        return ResponseEntity.create(200, body);
    }

    public static ResponseEntity badRequest() {
        return ResponseEntity.create(400, null);
    }

    public static ResponseEntity badRequest(Object body) {
        return ResponseEntity.create(400, body);
    }

    public static ResponseEntity notFound() {
        return ResponseEntity.create(404, null);
    }

    public static ResponseEntity notFound(Object body) {
        return ResponseEntity.create(404, body);
    }

    public static ResponseEntity noContent() {
        return ResponseEntity.create(204, null);
    }

    public <T> T getBody() {
        return (T)this.body;
    }

    public String getHeader(String name) {
        if (this.headers == null) {
            return null;
        }
        return this.headers.getValue(name);
    }

    public String getContentType() {
        return this.getHeader("Content-Type");
    }

    public String toString() {
        return "ResponseEntity(status: " + this.status + ", headers: " + this.headers + ", body: " + (this.body != null ? this.body.getClass().getSimpleName() : "null") + ")";
    }

    public static Builder builder() {
        return new Builder();
    }

    public int getStatus() {
        return this.status;
    }

    public MultiValueMap getHeaders() {
        return this.headers;
    }

    public static class Builder
    implements EzyBuilder<ResponseEntity> {
        protected Object body;
        protected int status = 200;
        protected Map<String, List<String>> headers;

        public Builder status(int status) {
            this.status = status;
            return this;
        }

        public Builder body(Object body) {
            this.body = body;
            return this;
        }

        public Builder textPlain(Object value) {
            this.textPlain();
            return this.body(value.toString());
        }

        public Builder textPlain() {
            return this.contentType("text/plain");
        }

        public Builder contentType(String contentType) {
            return this.header("Content-Type", contentType);
        }

        public Builder header(String name, String value) {
            if (this.headers == null) {
                this.headers = new HashMap<String, List<String>>();
            }
            this.headers.computeIfAbsent(name, k -> new ArrayList()).add(value);
            return this;
        }

        public Builder header(String name, List<String> values) {
            for (String value : values) {
                this.header(name, value);
            }
            return this;
        }

        public Builder headers(Map<String, String> headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.header(header.getKey(), header.getValue());
            }
            return this;
        }

        public ResponseEntity build() {
            return new ResponseEntity(this.status, this.headers, this.body);
        }
    }
}

