/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.web.controller;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.tvd12.ezyfox.bean.annotation.EzyAutoBind;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.DeserializeBodyException;
import com.tvd12.ezyhttp.core.exception.DeserializeValueException;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.core.exception.HttpNotFoundException;
import com.tvd12.ezyhttp.core.exception.HttpUnauthorizedException;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import com.tvd12.ezyhttp.server.core.annotation.TryCatch;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import com.tvd12.ezyhttp.server.core.view.Redirect;
import java.nio.file.InvalidPathException;
import java.util.Collections;
import java.util.HashMap;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.util.Utf8Appendable;
import org.youngmonkeys.ezyplatform.exception.AdminAccessTokenExpiredException;
import org.youngmonkeys.ezyplatform.exception.AdminInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.exception.BadRequestException;
import org.youngmonkeys.ezyplatform.exception.ForbiddenActionException;
import org.youngmonkeys.ezyplatform.exception.IncorrectPasswordException;
import org.youngmonkeys.ezyplatform.exception.PermissionDeniedException;
import org.youngmonkeys.ezyplatform.exception.ResourceNotFoundException;
import org.youngmonkeys.ezyplatform.exception.UserAccessTokenExpiredException;
import org.youngmonkeys.ezyplatform.exception.UserInvalidAccessTokenException;
import org.youngmonkeys.ezyplatform.service.SettingService;
import org.youngmonkeys.ezyplatform.util.HttpRequests;
import org.youngmonkeys.ezyplatform.web.view.WebViews;

public class WebGlobalExceptionHandler
extends EzyLoggable {
    @EzyAutoBind
    protected SettingService settingService;
    @EzyAutoBind
    protected RequestURIManager requestUriManager;

    @TryCatch(value={AdminInvalidAccessTokenException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, AdminInvalidAccessTokenException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("token", "invalid")).build();
        }
        return this.redirectToAdminLogin(request);
    }

    @TryCatch(value={AdminAccessTokenExpiredException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, AdminAccessTokenExpiredException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("adminToken", "expired")).build();
        }
        return this.redirectToAdminLogin(request);
    }

    @TryCatch(value={UserInvalidAccessTokenException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, UserInvalidAccessTokenException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("token", "invalid")).build();
        }
        return WebViews.redirectToLogin(request, true);
    }

    @TryCatch(value={UserAccessTokenExpiredException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, UserAccessTokenExpiredException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(Collections.singletonMap("token", "expired")).build();
        }
        return WebViews.redirectToLogin(request, true);
    }

    @TryCatch(value={IncorrectPasswordException.class})
    public ResponseEntity handle(IncorrectPasswordException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        return ResponseEntity.badRequest(Collections.singletonMap("password", "incorrect"));
    }

    @TryCatch(value={BadRequestException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, BadRequestException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.badRequest((Object)e.getErrors());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    @TryCatch(value={BadMessageException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, BadMessageException e) {
        return this.handleCommonBadRequestException(request, arguments, (Exception)e);
    }

    @TryCatch(value={InvalidPathException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, InvalidPathException e) {
        return this.handleCommonBadRequestException(request, arguments, e);
    }

    @TryCatch(value={Utf8Appendable.NotUtf8Exception.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, Utf8Appendable.NotUtf8Exception e) {
        return this.handleCommonBadRequestException(request, arguments, (Exception)e);
    }

    @TryCatch(value={IllegalArgumentException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, IllegalArgumentException e) {
        return this.handleCommonBadRequestException(request, arguments, e);
    }

    @TryCatch(value={ResourceNotFoundException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, ResourceNotFoundException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.notFound((Object)e.getResponseData());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={HttpUnauthorizedException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpUnauthorizedException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.builder().status(401).body(e.getData()).build();
        }
        return Redirect.builder().uri(HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/login")).addCookie("adminAccessToken", (Object)"").build();
    }

    @TryCatch(value={HttpNotFoundException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpNotFoundException e) {
        this.logger.debug("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.notFound((Object)e.getData());
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={ForbiddenActionException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, ForbiddenActionException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body((Object)e.getResponseData()).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/not-found"));
    }

    @TryCatch(value={PermissionDeniedException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, PermissionDeniedException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body(Collections.singletonMap("permission", "denied")).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/permission-denied"));
    }

    @TryCatch(value={HttpForbiddenException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, HttpForbiddenException e) {
        this.logger.info("{}({})", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.status((int)403).body(e.getData()).build();
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/permission-denied"));
    }

    @TryCatch(value={DeserializeBodyException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, DeserializeBodyException e) {
        this.logger.info("{}({})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            HashMap<String, String> errors = new HashMap<String, String>();
            Throwable cause = e.getCause();
            if (cause instanceof InvalidFormatException) {
                InvalidFormatException ex = (InvalidFormatException)cause;
                for (JsonMappingException.Reference ref : ex.getPath()) {
                    errors.put(ref.getFieldName(), "invalid");
                }
            } else {
                errors.put("fields", "invalid");
            }
            return ResponseEntity.badRequest(errors);
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    @TryCatch(value={DeserializeValueException.class})
    public Object handle(HttpServletRequest request, RequestArguments arguments, DeserializeValueException e) {
        this.logger.info("{}({})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.badRequest(Collections.singletonMap(e.getValueName(), "invalid"));
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    protected Object handleCommonBadRequestException(HttpServletRequest request, RequestArguments arguments, Exception e) {
        this.logger.info("{}({})", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
        HttpMethod method = arguments.getMethod();
        String uriTemplate = arguments.getUriTemplate();
        if (this.requestUriManager.isApiURI(method, uriTemplate)) {
            return ResponseEntity.badRequest(Collections.singletonMap("request", "invalid"));
        }
        return Redirect.to((String)HttpRequests.addLanguageToUri((HttpServletRequest)request, (String)"/bad-request"));
    }

    protected Redirect redirectToAdminLogin(HttpServletRequest request) {
        Cookie tokenCookie = new Cookie("adminAccessToken", "");
        tokenCookie.setPath("/");
        tokenCookie.setMaxAge(0);
        Cookie tokenCookieExpiredAt = new Cookie("adminAccessTokenExpiredAt", "0");
        tokenCookieExpiredAt.setMaxAge(0);
        tokenCookieExpiredAt.setPath("/");
        String adminLoginUri = this.settingService.getAdminUrl() + "/sso-web?callbackUrl=" + request.getRequestURI();
        String queryString = request.getQueryString();
        if (EzyStrings.isNotBlank((String)queryString)) {
            adminLoginUri = adminLoginUri + "?" + queryString;
        }
        return Redirect.builder().uri(adminLoginUri).addCookie(tokenCookie).addCookie(tokenCookieExpiredAt).build();
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    public void setRequestUriManager(RequestURIManager requestUriManager) {
        this.requestUriManager = requestUriManager;
    }
}

