/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.appender;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tvd12.ezyfox.io.EzyLists;
import java.time.LocalDateTime;
import java.util.List;
import org.youngmonkeys.ezyplatform.admin.appender.AdminDataIndexAppender;
import org.youngmonkeys.ezyplatform.admin.service.AdminDataIndexService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.constant.CommonConstants;
import org.youngmonkeys.ezyplatform.pagination.LastUpdatedAtPageToken;

public abstract class AdminLastUpdatedAtDataIndexAppender<V>
extends AdminDataIndexAppender<V, LastUpdatedAtPageToken> {
    public AdminLastUpdatedAtDataIndexAppender(ObjectMapper objectMapper, AdminSettingService settingService, AdminDataIndexService dataIndexService) {
        super(objectMapper, settingService, dataIndexService);
    }

    @Override
    protected LastUpdatedAtPageToken extractNewLastPageToken(List<V> valueList, LastUpdatedAtPageToken currentLastPageToken) {
        return currentLastPageToken.newLastPageToken(valueList.size(), () -> this.extractLastUpdatedAt(EzyLists.last((List)valueList)), () -> this.extractLastId(EzyLists.last((List)valueList)));
    }

    protected abstract LocalDateTime extractLastUpdatedAt(V var1);

    protected Object extractLastId(V value) {
        return null;
    }

    @Override
    protected LastUpdatedAtPageToken defaultPageToken() {
        return LastUpdatedAtPageToken.defaultPageToken((LocalDateTime)this.firstUpdatedAt());
    }

    protected LocalDateTime firstUpdatedAt() {
        return CommonConstants.MIN_SQL_DATETIME;
    }

    @Override
    protected Class<LastUpdatedAtPageToken> pageTokenType() {
        return LastUpdatedAtPageToken.class;
    }
}

