/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.controller.view;

import com.tvd12.ezyfox.annotation.EzyFeature;
import com.tvd12.ezyhttp.server.core.annotation.Authenticated;
import com.tvd12.ezyhttp.server.core.annotation.Controller;
import com.tvd12.ezyhttp.server.core.annotation.DoGet;
import com.tvd12.ezyhttp.server.core.annotation.PathVariable;
import com.tvd12.ezyhttp.server.core.view.View;
import org.youngmonkeys.ezyplatform.admin.view.AdminViewFactory;
import org.youngmonkeys.ezyplatform.entity.ModuleType;

@Authenticated
@Controller
@EzyFeature(value="plugin_management")
public class AdminPluginsController {
    private final AdminViewFactory viewFactory;

    @DoGet(value="/plugins")
    public View pluginsGet() {
        return this.newPluginsViewBuilder(null).build();
    }

    @DoGet(value="/web-plugins")
    public View webPluginsGet() {
        return this.newPluginsViewBuilder(ModuleType.WEB_PLUGIN).build();
    }

    @DoGet(value="/socket-plugins")
    public View socketPluginsGet() {
        return this.newPluginsViewBuilder(ModuleType.SOCKET_PLUGIN).build();
    }

    @DoGet(value="/admin-plugins")
    public View adminPluginsGet() {
        return this.newPluginsViewBuilder(ModuleType.ADMIN_PLUGIN).build();
    }

    @DoGet(value="/admin-plugins/{pluginName}")
    public View adminPluginsPluginNameGet(@PathVariable(value="pluginName") String pluginName) {
        return this.viewFactory.newModuleDetailsViewBuilder(ModuleType.ADMIN_PLUGIN, pluginName).build();
    }

    @DoGet(value="/socket-plugins/{pluginName}")
    public View socketPluginsPluginNameGet(@PathVariable(value="pluginName") String pluginName) {
        return this.viewFactory.newModuleDetailsViewBuilder(ModuleType.SOCKET_PLUGIN, pluginName).build();
    }

    @DoGet(value="/web-plugins/{pluginName}")
    public View webPluginsPluginNameGet(@PathVariable(value="pluginName") String pluginName) {
        return this.viewFactory.newModuleDetailsViewBuilder(ModuleType.WEB_PLUGIN, pluginName).build();
    }

    private View.Builder newPluginsViewBuilder(ModuleType moduleType) {
        return this.viewFactory.newModulesViewBuilder(moduleType);
    }

    public AdminPluginsController(AdminViewFactory viewFactory) {
        this.viewFactory = viewFactory;
    }
}

