/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.interceptor;

import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyhttp.core.annotation.Interceptor;
import com.tvd12.ezyhttp.core.constant.HttpMethod;
import com.tvd12.ezyhttp.core.exception.HttpForbiddenException;
import com.tvd12.ezyhttp.server.core.interceptor.RequestInterceptor;
import com.tvd12.ezyhttp.server.core.manager.FeatureURIManager;
import com.tvd12.ezyhttp.server.core.manager.RequestURIManager;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.http.HttpServletRequest;
import org.youngmonkeys.ezyplatform.admin.exception.SuperAdminNotExistedException;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminRoleService;
import org.youngmonkeys.ezyplatform.admin.service.AdminAdminService;
import org.youngmonkeys.ezyplatform.admin.service.AdminRoleFeatureService;
import org.youngmonkeys.ezyplatform.admin.service.AdminSettingService;
import org.youngmonkeys.ezyplatform.annotation.AccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminAccessToken;
import org.youngmonkeys.ezyplatform.annotation.AdminId;
import org.youngmonkeys.ezyplatform.annotation.AdminRoles;
import org.youngmonkeys.ezyplatform.data.AdminRolesProxy;

@Interceptor
public class AdminAuthenticationInterceptor
implements RequestInterceptor {
    private final AdminAdminService adminService;
    private final AdminAdminRoleService adminRoleService;
    private final AdminRoleFeatureService roleFeatureService;
    private final AdminSettingService settingService;
    private final RequestURIManager requestUriManager;
    private final FeatureURIManager featureUriManager;
    private final AtomicBoolean hasSuperAdmin = new AtomicBoolean(false);
    private static final Set<String> PUBLIC_URIS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"/favicon.ico", "/login", "/setup-admin", "/sso-web", "/sso-login", "/css/all.min.css", "/css/all.min.css.map", "/css/icheck-bootstrap.min.css", "/css/icheck-bootstrap.min.css.map", "/css/adminlte.min.css", "/css/adminlte.min.css.map", "/fonts/fa-brands-400.woff2", "/fonts/fa-regular-400.ttf", "/fonts/fa-regular-400.woff", "/fonts/fa-regular-400.woff2", "/fonts/fa-solid-900.ttf", "/fonts/fa-solid-900.woff", "/fonts/fa-solid-900.woff2", "/js/jquery.min.js", "/js/jquery.min.js.map", "/js/bootstrap.bundle.min.js", "/js/bootstrap.bundle.min.js.map", "/js/adminlte.min.js", "/js/adminlte.min.js.map"}));

    public boolean preHandle(RequestArguments arguments, Method handler) {
        String accessToken = arguments.getHeader("adminAccessToken");
        if (accessToken == null) {
            accessToken = arguments.getCookieValue("adminAccessToken");
        }
        HttpServletRequest request = arguments.getRequest();
        request.setAttribute("adminAccessToken", (Object)accessToken);
        arguments.setArgument(AccessToken.class, (Object)accessToken);
        arguments.setArgument(AdminAccessToken.class, (Object)accessToken);
        String uri = request.getRequestURI();
        if (PUBLIC_URIS.contains(uri)) {
            return true;
        }
        String uriTemplate = arguments.getUriTemplate();
        Set<String> autoPassUris = this.settingService.getAutoPassManagementUris();
        if (autoPassUris.contains(uriTemplate)) {
            return true;
        }
        this.ensureSuperAdmin();
        long adminId = this.adminService.validateAdminAccessToken(accessToken);
        arguments.setArgument(AdminId.class, (Object)adminId);
        request.setAttribute(AdminId.class.getName(), (Object)adminId);
        HttpMethod method = arguments.getMethod();
        if (this.requestUriManager.isAuthenticatedURI(method, uriTemplate)) {
            AdminRolesProxy adminRolesProxy = this.checkPermission(method, uriTemplate, adminId);
            arguments.setArgument(AdminRoles.class, (Object)adminRolesProxy);
            request.setAttribute(AdminRoles.class.getName(), (Object)adminRolesProxy);
        }
        return true;
    }

    private void ensureSuperAdmin() {
        if (!this.hasSuperAdmin.get()) {
            this.hasSuperAdmin.set(this.adminRoleService.hasActiveSuperAdmin());
            if (!this.hasSuperAdmin.get()) {
                throw new SuperAdminNotExistedException();
            }
        }
    }

    private AdminRolesProxy checkPermission(HttpMethod method, String uriTemplate, long adminId) {
        String feature = this.featureUriManager.getFeatureByURI(method, uriTemplate);
        Set<Long> roleIds = this.adminRoleService.getRoleIdsByAdminId(adminId);
        Set<Long> specialRoleIds = this.adminRoleService.getSpecialRoleIds();
        Map methodsUriMapByFeatureByRoleId = this.roleFeatureService.getMethodsUriMapByFeatureByRoleId();
        if (feature != null) {
            boolean hasPermission = false;
            for (Long roleId : roleIds) {
                Set methods;
                Map methodsUriMap;
                if (specialRoleIds.contains(roleId)) {
                    hasPermission = true;
                    break;
                }
                Map methodsUriMapByFeature = (Map)methodsUriMapByFeatureByRoleId.get(roleId);
                if (methodsUriMapByFeature == null || (methodsUriMap = (Map)methodsUriMapByFeature.get(feature)) == null || (methods = (Set)methodsUriMap.get(uriTemplate)) == null || !methods.contains(method)) continue;
                hasPermission = true;
                break;
            }
            if (!hasPermission) {
                throw new HttpForbiddenException(Collections.singletonMap("permission", "denied"));
            }
        }
        return AdminRolesProxy.create(roleIds, (long)this.adminRoleService.getSuperAdminRoleId(), specialRoleIds, (FeatureURIManager)this.featureUriManager, (Map)methodsUriMapByFeatureByRoleId);
    }

    public AdminAuthenticationInterceptor(AdminAdminService adminService, AdminAdminRoleService adminRoleService, AdminRoleFeatureService roleFeatureService, AdminSettingService settingService, RequestURIManager requestUriManager, FeatureURIManager featureUriManager) {
        this.adminService = adminService;
        this.adminRoleService = adminRoleService;
        this.roleFeatureService = roleFeatureService;
        this.settingService = settingService;
        this.requestUriManager = requestUriManager;
        this.featureUriManager = featureUriManager;
    }
}

