/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.admin.manager;

import com.tvd12.ezyfox.bean.annotation.EzySingleton;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.youngmonkeys.ezyplatform.admin.manager.AdminFileSystemManager;
import org.youngmonkeys.ezyplatform.data.FileItem;
import org.youngmonkeys.ezyplatform.io.FolderProxy;

@EzySingleton
public class AdminEzyPlatformFileManager {
    private AdminFileSystemManager fileSystemManager;
    private static final String FILE_EXTENSION_JAR = ".jar";

    public void moveFilesToPlatformFolder(File fromFolder) {
        List inclusiveFiles = this.listIncludeToPlatformFiles(fromFolder).stream().map(FileItem::getRelativePath).filter(relativePath -> !AdminFileSystemManager.TOOLS_AND_SCRIPT_PATHS.contains(relativePath)).collect(Collectors.toList());
        if (inclusiveFiles.isEmpty()) {
            return;
        }
        File platformFolder = this.fileSystemManager.getNewEzyPlatformFolder();
        FolderProxy.mkdirs((File)platformFolder);
        File updateFilesPath = this.fileSystemManager.getNewEzyPlatformUpdateFilesFile();
        FolderProxy.writeDistinctLines((File)updateFilesPath, inclusiveFiles);
        FolderProxy.copyAndDeleteFolder((File)fromFolder, (File)platformFolder);
    }

    public List<FileItem> listIncludeToPlatformFiles(File backupFolder) {
        return FolderProxy.listFileItems((File)backupFolder, (int)3, FolderProxy.isNotHiddenFilePredicate().and(FolderProxy.fileHasNotExtensionPredicate((String)FILE_EXTENSION_JAR)));
    }

    public AdminEzyPlatformFileManager(AdminFileSystemManager fileSystemManager) {
        this.fileSystemManager = fileSystemManager;
    }
}

