/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfoxserver.setting;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfoxserver.setting.EzyAdminSetting;
import com.tvd12.ezyfoxserver.setting.EzyAdminsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleAdminSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="administrators")
public class EzySimpleAdminsSetting
implements EzyAdminsSetting {
    protected List<EzyAdminSetting> admins = new ArrayList<EzyAdminSetting>();
    protected Map<String, EzyAdminSetting> adminsByName = new ConcurrentHashMap<String, EzyAdminSetting>();
    protected Map<String, EzyAdminSetting> adminsByAccessToken = new ConcurrentHashMap<String, EzyAdminSetting>();

    @XmlElement(name="administrator")
    public void setItem(EzySimpleAdminSetting item) {
        if (!EzyStrings.isNoContent((String)item.getUsername())) {
            this.adminsByName.put(item.getUsername(), item);
        }
        if (!EzyStrings.isNoContent((String)item.getAccessToken())) {
            this.adminsByAccessToken.put(item.getAccessToken(), item);
        }
        this.admins.add(item);
    }

    @Override
    public List<EzyAdminSetting> getAdmins() {
        return new ArrayList<EzyAdminSetting>(this.adminsByName.values());
    }

    @Override
    public EzyAdminSetting getAdminByName(String username) {
        return this.adminsByName.get(username);
    }

    @Override
    public EzyAdminSetting getAdminByAccessToken(String token) {
        return this.adminsByAccessToken.get(token);
    }

    @Override
    public boolean containsAdminByName(String username) {
        return this.adminsByName.containsKey(username);
    }

    @Override
    public boolean containsAdminByAccessToken(String token) {
        return this.adminsByAccessToken.containsKey(token);
    }

    public Map<Object, Object> toMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        ArrayList<Map> adminMaps = new ArrayList<Map>();
        for (EzyAdminSetting admin : this.adminsByName.values()) {
            adminMaps.add(admin.toMap());
        }
        map.put("count", this.adminsByName.size());
        map.put("admins", adminMaps);
        return map;
    }

    public void setAdmins(List<EzyAdminSetting> admins) {
        this.admins = admins;
    }

    public void setAdminsByName(Map<String, EzyAdminSetting> adminsByName) {
        this.adminsByName = adminsByName;
    }

    public void setAdminsByAccessToken(Map<String, EzyAdminSetting> adminsByAccessToken) {
        this.adminsByAccessToken = adminsByAccessToken;
    }

    public Map<String, EzyAdminSetting> getAdminsByName() {
        return this.adminsByName;
    }

    public Map<String, EzyAdminSetting> getAdminsByAccessToken() {
        return this.adminsByAccessToken;
    }

    public String toString() {
        return "EzySimpleAdminsSetting(admins=" + this.getAdmins() + ", adminsByName=" + this.getAdminsByName() + ", adminsByAccessToken=" + this.getAdminsByAccessToken() + ")";
    }
}

