/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.server.core.asm;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClassTree;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyhttp.server.core.asm.AbstractHandlerImplementer;
import com.tvd12.ezyhttp.server.core.asm.AsmAbstractUncaughtExceptionHandler;
import com.tvd12.ezyhttp.server.core.asm.AsmUncaughtExceptionHandler;
import com.tvd12.ezyhttp.server.core.handler.UncaughtExceptionHandler;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerMethod;
import com.tvd12.ezyhttp.server.core.reflect.ExceptionHandlerProxy;
import com.tvd12.ezyhttp.server.core.request.RequestArguments;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtNewMethod;

public class ExceptionHandlerImplementer
extends AbstractHandlerImplementer<ExceptionHandlerMethod> {
    private static boolean debug;
    protected final ExceptionHandlerProxy exceptionHandler;
    protected static final AtomicInteger COUNT;

    public ExceptionHandlerImplementer(ExceptionHandlerProxy exceptionHandler, ExceptionHandlerMethod handlerMethod) {
        super(handlerMethod);
        this.exceptionHandler = exceptionHandler;
    }

    public UncaughtExceptionHandler implement() {
        try {
            return this.doImplement();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected UncaughtExceptionHandler doImplement() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyClass superClass = new EzyClass(this.getSuperClass());
        String exceptionHandlerFieldContent = this.makeExceptionHandlerFieldContent();
        String setExceptionHandlerMethodContent = this.makeSetExceptionHandlerMethodContent();
        String handleExceptionMethodContent = this.makeHandleExceptionMethodContent();
        String getResponseContentTypeMethodContent = this.makeGetResponseContentTypeMethodContent();
        this.printComponentContent(implClassName);
        this.printComponentContent(exceptionHandlerFieldContent);
        this.printComponentContent(setExceptionHandlerMethodContent);
        this.printComponentContent(handleExceptionMethodContent);
        this.printComponentContent(getResponseContentTypeMethodContent);
        implClass.setSuperclass(pool.get(superClass.getName()));
        implClass.addField(CtField.make((String)exceptionHandlerFieldContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)setExceptionHandlerMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)handleExceptionMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)getResponseContentTypeMethodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        AsmUncaughtExceptionHandler handler = (AsmUncaughtExceptionHandler)answerClass.newInstance();
        this.setRepoComponent(handler);
        return handler;
    }

    protected void setRepoComponent(AsmUncaughtExceptionHandler handler) {
        handler.setExceptionHandler(this.exceptionHandler.getInstance());
    }

    protected String makeExceptionHandlerFieldContent() {
        return new EzyInstruction().append("private ").append(this.exceptionHandler.getClazz().getName()).append(" exceptionHandler").toString();
    }

    protected String makeSetExceptionHandlerMethodContent() {
        return new EzyFunction(this.getSetExceptionHandlerMethod()).body().append(new EzyInstruction("\t", "\n").append("this.exceptionHandler").equal().brackets(this.exceptionHandler.getClazz().getClazz()).append("arg0")).function().toString();
    }

    protected String makeHandleExceptionMethodContent() {
        EzyMethod method = this.getHandleExceptionMethod();
        EzyFunction function = new EzyFunction(method);
        EzyFunction.EzyBody body = function.body();
        Class[] exceptionClasses = ((ExceptionHandlerMethod)this.handlerMethod).getExceptionClasses();
        EzyClassTree exceptionTree = new EzyClassTree(exceptionClasses);
        for (Class exceptionClass : exceptionTree.toList()) {
            EzyInstruction instructionIf = new EzyInstruction("\t", "\n", false).append("if (arg1 instanceof ").append(exceptionClass.getName()).append(") {");
            body.append(instructionIf);
            EzyInstruction instructionHandle = new EzyInstruction("\t\t", "\n");
            Class<?> returnType = ((ExceptionHandlerMethod)this.handlerMethod).getReturnType();
            if (returnType != Void.TYPE) {
                instructionHandle.answer();
            }
            instructionHandle.append("this.exceptionHandler.").append(((ExceptionHandlerMethod)this.handlerMethod).getName()).bracketopen();
            this.appendHandleExceptionMethodArguments((ExceptionHandlerMethod)this.handlerMethod, instructionHandle, exceptionClass);
            instructionHandle.bracketclose();
            body.append(instructionHandle);
            if (returnType == Void.TYPE) {
                body.append(new EzyInstruction("\t\t", "\n").append("return null"));
            }
            body.append(new EzyInstruction("\t", "\n", false).append("}"));
        }
        body.append(new EzyInstruction("\t", "\n").append("throw arg1"));
        return this.toThrowExceptionFunction(method, function);
    }

    protected String makeGetResponseContentTypeMethodContent() {
        return new EzyFunction(this.getGetResponseContentTypeMethod()).body().append(new EzyInstruction("\t", "\n").answer().string(((ExceptionHandlerMethod)this.handlerMethod).getResponseType())).function().toString();
    }

    protected String toThrowExceptionFunction(EzyMethod method, EzyFunction function) {
        return method.getDeclaration("public") + " throws Exception {\n" + function.body() + "}";
    }

    protected EzyMethod getSetExceptionHandlerMethod() {
        Method method = EzyMethods.getMethod(AsmAbstractUncaughtExceptionHandler.class, (String)"setExceptionHandler", (Class[])new Class[]{Object.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getHandleExceptionMethod() {
        Method method = EzyMethods.getMethod(AsmAbstractUncaughtExceptionHandler.class, (String)"handleException", (Class[])new Class[]{RequestArguments.class, Exception.class});
        return new EzyMethod(method);
    }

    protected EzyMethod getGetResponseContentTypeMethod() {
        Method method = EzyMethods.getMethod(AsmAbstractUncaughtExceptionHandler.class, (String)"getResponseContentType", (Class[])new Class[0]);
        return new EzyMethod(method);
    }

    protected Class<?> getSuperClass() {
        return AsmAbstractUncaughtExceptionHandler.class;
    }

    protected String getImplClassName() {
        return this.exceptionHandler.getClassSimpleName() + "$" + ((ExceptionHandlerMethod)this.handlerMethod).getName() + "$ExceptionHandler$AutoImpl$" + COUNT.incrementAndGet();
    }

    protected void printComponentContent(String componentContent) {
        if (debug) {
            this.logger.debug("component content: \n{}", (Object)componentContent);
        }
    }

    public static void setDebug(boolean debug) {
        ExceptionHandlerImplementer.debug = debug;
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

