/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database;

import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.database.EzyDatabaseContextAware;
import com.tvd12.ezydata.database.EzyDatabaseRepositoryWrapper;
import com.tvd12.ezydata.database.EzySimpleDatabaseContext;
import com.tvd12.ezydata.database.bean.EzyAbstractRepositoriesImplementer;
import com.tvd12.ezydata.database.converter.EzyBindResultDeserializer;
import com.tvd12.ezydata.database.converter.EzyResultDeserializer;
import com.tvd12.ezydata.database.converter.EzySimpleResultDeserializers;
import com.tvd12.ezydata.database.query.EzyQueryEntity;
import com.tvd12.ezydata.database.query.EzyQueryMethodConverter;
import com.tvd12.ezydata.database.query.EzySimpleQueryManager;
import com.tvd12.ezydata.database.util.EzyDatabasePropertiesKeeper;
import com.tvd12.ezyfox.binding.EzyBindingContext;
import com.tvd12.ezyfox.binding.EzyBindingContextBuilder;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.binding.impl.EzySimpleBindingContext;
import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.collect.Sets;
import com.tvd12.ezyfox.database.annotation.EzyNamedQuery;
import com.tvd12.ezyfox.database.annotation.EzyQueryResult;
import com.tvd12.ezyfox.database.annotation.EzyRepository;
import com.tvd12.ezyfox.database.annotation.EzyResultDeserialized;
import com.tvd12.ezyfox.io.EzyLists;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyReflection;
import com.tvd12.ezyfox.reflect.EzyReflectionProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class EzyDatabaseContextBuilder<B extends EzyDatabaseContextBuilder<B>>
extends EzyDatabasePropertiesKeeper<B>
implements EzyBuilder<EzyDatabaseContext> {
    protected Set<String> packagesToScan;
    protected Set<Class<?>> repositoryClasses;
    protected Set<Class<?>> autoImplInterfaces;
    protected Set<Class<?>> queryResultClasses;
    protected List<EzyReflection> reflections = new ArrayList<EzyReflection>();
    protected Map<Class<?>, Object> repositories;
    protected EzySimpleQueryManager queryManager;
    protected EzyQueryMethodConverter queryMethodConverter;
    protected EzyBindingContextBuilder bindingContextBuilder;
    protected EzySimpleResultDeserializers resultDeserializers;
    protected EzyDatabaseRepositoryWrapper repositoryWrapper;

    public EzyDatabaseContextBuilder() {
        this.packagesToScan = new HashSet<String>();
        this.repositoryClasses = new HashSet();
        this.autoImplInterfaces = new HashSet();
        this.queryResultClasses = new HashSet();
        this.repositories = new HashMap();
        this.queryManager = new EzySimpleQueryManager();
        this.queryMethodConverter = this.newQueryMethodConverter();
        this.resultDeserializers = new EzySimpleResultDeserializers();
        this.repositoryWrapper = EzyDatabaseRepositoryWrapper.DEFAULT;
    }

    protected EzyQueryMethodConverter newQueryMethodConverter() {
        return null;
    }

    public B addQuery(EzyQueryEntity query) {
        this.queryManager.addQuery(query);
        return (B)((Object)this);
    }

    public B addQueries(Iterable<EzyQueryEntity> queries) {
        for (EzyQueryEntity query : queries) {
            this.addQuery(query);
        }
        return (B)((Object)this);
    }

    public B scan(String packageName) {
        this.packagesToScan.add(packageName);
        return (B)((Object)this);
    }

    public B scan(String ... packageNames) {
        return this.scan(Sets.newHashSet((Object[])packageNames));
    }

    public B scan(Iterable<String> packageNames) {
        for (String packageName : packageNames) {
            this.scan(packageName);
        }
        return (B)((Object)this);
    }

    public B scan(EzyReflection reflection) {
        this.reflections.add(reflection);
        return (B)((Object)this);
    }

    public B repositoryInterface(Class<?> itf) {
        this.autoImplInterfaces.add(itf);
        return (B)((Object)this);
    }

    public B repositoryInterfaces(Class<?> ... interfaces) {
        return this.repositoryInterfaces(Sets.newHashSet((Object[])interfaces));
    }

    public B repositoryInterfaces(Iterable<Class<?>> interfaces) {
        for (Class<?> itf : interfaces) {
            this.repositoryInterface(itf);
        }
        return (B)((Object)this);
    }

    public B repositoryClass(Class<?> repoClass) {
        this.repositoryClasses.add(repoClass);
        return (B)((Object)this);
    }

    public B repositoryClasses(Class<?> ... repoClasses) {
        return this.repositoryClasses(Sets.newHashSet((Object[])repoClasses));
    }

    public B repositoryClasses(Iterable<Class<?>> repoClasses) {
        for (Class<?> repoClass : repoClasses) {
            this.repositoryClass(repoClass);
        }
        return (B)((Object)this);
    }

    public B queryResultClass(Class<?> resultClass) {
        this.queryResultClasses.add(resultClass);
        return (B)((Object)this);
    }

    public B queryResultClasses(Class<?> ... resultClasses) {
        return this.queryResultClasses(Sets.newHashSet((Object[])resultClasses));
    }

    public B queryResultClasses(Iterable<Class<?>> resultClasses) {
        for (Class<?> resultClass : resultClasses) {
            this.queryResultClasses.add(resultClass);
        }
        return (B)((Object)this);
    }

    public B bindingContextBuilder(EzyBindingContextBuilder bindingContextBuilder) {
        this.bindingContextBuilder = bindingContextBuilder;
        return (B)((Object)this);
    }

    public B addResultDeserializer(Class<?> resultType, EzyResultDeserializer deserializer) {
        this.queryResultClasses.add(resultType);
        this.resultDeserializers.addDeserializer(resultType, deserializer);
        return (B)((Object)this);
    }

    public B addResultDeserializers(Map<Class<?>, EzyResultDeserializer> deserializers) {
        for (Class<?> resultType : deserializers.keySet()) {
            EzyResultDeserializer deserializer = deserializers.get(resultType);
            this.addResultDeserializer(resultType, deserializer);
        }
        return (B)((Object)this);
    }

    public EzyDatabaseContext build() {
        if (this.packagesToScan.size() > 0) {
            this.reflections.add((EzyReflection)new EzyReflectionProxy(this.packagesToScan));
        }
        if (this.bindingContextBuilder == null) {
            this.bindingContextBuilder = EzyBindingContext.builder();
        }
        for (EzyReflection reflection : this.reflections) {
            this.bindingContextBuilder.addAllClasses((Object)reflection);
        }
        this.preBuild();
        this.scanAndAddQueries();
        this.scanAndAddResultTypes();
        this.scanAndAddRepoClasses();
        EzySimpleDatabaseContext context = this.newDatabaseContext();
        context.setQueryManager(this.queryManager);
        context.setDeserializers(this.resultDeserializers);
        this.addRepositoriesFromClasses(context);
        this.implementAutoImplRepositories(context);
        this.scanAndAddResultDeserializers();
        this.addQueryResultClassesFromQueryManager();
        Set<Class<?>> unknownDeserializerResultTypes = this.getUnknownDeserializerResultClasses();
        this.bindUnknownDeserializerResultClasses(unknownDeserializerResultTypes);
        EzySimpleBindingContext bindingContext = this.bindingContextBuilder.build();
        this.createUnknownResultDeserializers((EzyBindingContext)bindingContext, unknownDeserializerResultTypes);
        context.setRepositories(this.repositories);
        this.printDatabaseContextInformation(context);
        this.postBuild(context, (EzyBindingContext)bindingContext);
        return context;
    }

    protected abstract EzySimpleDatabaseContext newDatabaseContext();

    protected void preBuild() {
    }

    protected void postBuild(EzySimpleDatabaseContext context, EzyBindingContext bindingContext) {
    }

    protected void scanAndAddQueries() {
        for (EzyReflection reflection : this.reflections) {
            this.scanAndAddNamedQueries(reflection);
            this.scanAndAddQueries(reflection);
        }
    }

    protected void scanAndAddQueries(EzyReflection reflection) {
    }

    protected void scanAndAddNamedQueries(EzyReflection reflection) {
        Set resultClasses = reflection.getAnnotatedClasses(EzyNamedQuery.class);
        for (Class resultClass : resultClasses) {
            EzyNamedQuery anno = resultClass.getAnnotation(EzyNamedQuery.class);
            this.doAddQuery(anno.name(), anno.type(), anno.value(), resultClass, anno.nativeQuery());
        }
    }

    protected void doAddQuery(String name, String type, String value, Class<?> resultClass, boolean nativeQuery) {
        EzyQueryEntity queryEntity;
        String queryName = name;
        if (EzyStrings.isNoContent((String)name)) {
            queryName = resultClass.getName();
        }
        if ((queryEntity = this.queryManager.getQuery(queryName)) != null) {
            if (queryEntity.getResultType() != resultClass) {
                throw new IllegalStateException("too many result type of query: " + queryName + "(" + queryEntity.getResultType().getName() + ", " + resultClass.getName() + ")");
            }
        } else {
            if (EzyStrings.isNoContent((String)value)) {
                throw new IllegalStateException("has no query with name: " + queryName);
            }
            queryEntity = EzyQueryEntity.builder().name(queryName).type(type).value(value).resultType(resultClass).nativeQuery(nativeQuery).build();
            this.queryManager.addQuery(queryEntity);
        }
    }

    protected void scanAndAddRepoClasses() {
        for (EzyReflection reflection : this.reflections) {
            this.repositoryClasses.addAll(EzyLists.filter((Collection)reflection.getAnnotatedClasses(EzyRepository.class), it -> !it.isInterface()));
        }
    }

    protected void scanAndAddResultTypes() {
        for (EzyReflection reflection : this.reflections) {
            this.queryResultClasses.addAll(reflection.getAnnotatedClasses(EzyQueryResult.class));
        }
    }

    protected void scanAndAddResultDeserializers() {
        for (EzyReflection reflection : this.reflections) {
            this.scanAndAddResultDeserializers(reflection);
        }
    }

    protected void scanAndAddResultDeserializers(EzyReflection reflection) {
        Set classes = reflection.getAnnotatedClasses(EzyResultDeserialized.class);
        for (Class clazz : classes) {
            EzyResultDeserialized anno = clazz.getAnnotation(EzyResultDeserialized.class);
            Class resultType = anno.value();
            if (EzyResultDeserializer.class.isAssignableFrom(clazz)) {
                EzyResultDeserializer deserializer = (EzyResultDeserializer)EzyClasses.newInstance((Class)clazz);
                this.resultDeserializers.addDeserializer(resultType, deserializer);
                continue;
            }
            throw new IllegalStateException(clazz + " must implement interface " + EzyResultDeserializer.class.getName());
        }
    }

    private void addQueryResultClassesFromQueryManager() {
        Map<String, EzyQueryEntity> queries = this.queryManager.getQueries();
        for (EzyQueryEntity query : queries.values()) {
            Class<?> resultType = query.getResultType();
            if (resultType == Object.class) continue;
            this.queryResultClasses.add(resultType);
        }
    }

    private Set<Class<?>> getUnknownDeserializerResultClasses() {
        HashSet unknownDeserializerResultTypes = new HashSet();
        for (Class<?> resultType : this.queryResultClasses) {
            EzyResultDeserializer ds = this.resultDeserializers.getDeserializer(resultType);
            if (ds != null) continue;
            unknownDeserializerResultTypes.add(resultType);
        }
        return unknownDeserializerResultTypes;
    }

    private void bindUnknownDeserializerResultClasses(Set<Class<?>> unknownDeserializerResultTypes) {
        for (Class<?> resultType : unknownDeserializerResultTypes) {
            this.bindResultType(resultType);
        }
    }

    private void createUnknownResultDeserializers(EzyBindingContext bindingContext, Set<Class<?>> unknownDeserializerResultTypes) {
        EzyUnmarshaller unmarshaller = bindingContext.newUnmarshaller();
        for (Class<?> resultType : unknownDeserializerResultTypes) {
            EzyResultDeserializer deserializer = this.newUnknownResultDeserializer(resultType, unmarshaller);
            this.resultDeserializers.addDeserializer(resultType, deserializer);
        }
    }

    protected EzyResultDeserializer newUnknownResultDeserializer(Class<?> resultType, EzyUnmarshaller unmarshaller) {
        return new EzyBindResultDeserializer(resultType, unmarshaller);
    }

    protected void bindResultType(Class<?> resultType) {
        this.bindingContextBuilder.addClass(resultType);
    }

    protected void addRepositoriesFromClasses(EzyDatabaseContext context) {
        for (Class<?> repoClass : this.repositoryClasses) {
            this.addRepositoryFromClass(context, repoClass);
        }
    }

    protected void addRepositoryFromClass(EzyDatabaseContext context, Class<?> repoClass) {
        try {
            Object repo = EzyClasses.newInstance(repoClass);
            if (repo instanceof EzyDatabaseContextAware) {
                ((EzyDatabaseContextAware)repo).setDatabaseContext(context);
            }
            this.postCreateRepositoryFromClass(context, repo);
            this.repositories.put(repoClass, repo);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("create repo of class: " + repoClass.getName() + " error", e);
        }
    }

    protected void postCreateRepositoryFromClass(EzyDatabaseContext context, Object repo) {
    }

    private void implementAutoImplRepositories(EzySimpleDatabaseContext context) {
        EzyAbstractRepositoriesImplementer implementer = this.createRepositoriesImplementer();
        this.repositories.putAll(implementer.implement(context));
    }

    private EzyAbstractRepositoriesImplementer createRepositoriesImplementer() {
        EzyAbstractRepositoriesImplementer answer = this.newRepositoriesImplementer();
        answer.queryManager(this.queryManager);
        answer.queryMethodConverter(this.queryMethodConverter);
        answer.repositoryWrapper(this.repositoryWrapper);
        for (EzyReflection reflection : this.reflections) {
            answer.repositoryInterfaces(reflection);
        }
        answer.repositoryInterfaces(this.autoImplInterfaces);
        for (EzyReflection reflection : this.reflections) {
            answer.repositoryInterfaces(reflection);
        }
        return answer;
    }

    protected abstract EzyAbstractRepositoriesImplementer newRepositoriesImplementer();

    protected void printDatabaseContextInformation(EzyDatabaseContext context) {
        this.logger.debug("\n{}\n{}\n{}", new Object[]{"====================== DATABASE CONTEXT ===============", context, "======================================================="});
    }
}

