/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.mapping.jaxb;

import com.tvd12.ezyfox.mapping.jaxb.EzyXmlMapper;
import java.io.File;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class EzySimpleXmlMapper
implements EzyXmlMapper {
    private final Unmarshaller unmarshaller;

    private EzySimpleXmlMapper(Builder builder) {
        this.unmarshaller = builder.newUnmarshaller();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> T read(File xmlFile, Class<T> outputType) {
        try {
            return (T)this.unmarshaller.unmarshal((Source)new StreamSource(xmlFile), outputType).getValue();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Can not read xml file " + xmlFile.getAbsolutePath() + " with " + outputType, e);
        }
    }

    public static class Builder {
        private String contextPath;
        private ClassLoader classLoader;

        public Builder contextClass(Class<?> clazz) {
            this.classLoader = clazz.getClassLoader();
            this.contextPath = clazz.getPackage().getName();
            return this;
        }

        public Builder contextPath(String contextPath) {
            this.contextPath = contextPath;
            return this;
        }

        public Builder classLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        protected Unmarshaller newUnmarshaller() {
            try {
                JAXBContext context = this.newJAXBContext();
                return context.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public EzySimpleXmlMapper build() {
            return new EzySimpleXmlMapper(this);
        }

        protected JAXBContext newJAXBContext() throws JAXBException {
            return JAXBContext.newInstance((String)this.contextPath, (ClassLoader)this.classLoader);
        }
    }
}

