/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.binding.EzyReader;
import com.tvd12.ezyfox.binding.EzyUnmarshaller;
import com.tvd12.ezyfox.binding.annotation.EzyPostRead;
import com.tvd12.ezyfox.binding.exception.EzyReadValueException;
import com.tvd12.ezyfox.binding.impl.EzyAbstractBuilder;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyClasses;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyReflectElement;
import com.tvd12.ezyfox.reflect.EzySetterMethod;
import com.tvd12.ezyfox.reflect.EzyTypes;
import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;

public abstract class EzyAbstractReaderBuilder
extends EzyAbstractBuilder<EzySetterMethod> {
    protected final List<EzyMethod> postReadMethods = this.getPostReadMethods();

    public EzyAbstractReaderBuilder(EzyClass clazz) {
        super(clazz);
    }

    private List<EzyMethod> getPostReadMethods() {
        return this.clazz.getPublicMethods(m -> m.isAnnotated(EzyPostRead.class));
    }

    public <T> T build() {
        try {
            return (T)this.make();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    protected Object make() throws Exception {
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyMethod readMethod = this.getReadMethod();
        readMethod.setDisplayName(this.getReadMethodName() + "$impl");
        String implMethodContent = this.makeImplMethodContent(readMethod);
        readMethod.setDisplayName(this.getReadMethodName());
        String methodContent = this.makeMethodContent(readMethod);
        this.printMethodContent(methodContent);
        this.printMethodContent(implMethodContent);
        implClass.setInterfaces(new CtClass[]{pool.makeClass(this.getReaderInterface().getName())});
        implClass.addMethod(CtNewMethod.make((String)implMethodContent, (CtClass)implClass));
        implClass.addMethod(CtNewMethod.make((String)methodContent, (CtClass)implClass));
        Class answerClass = implClass.toClass();
        implClass.detach();
        this.logger.debug("class {} has generated", (Object)implClassName);
        return EzyClasses.newInstance((Class)answerClass);
    }

    protected String getReadMethodName() {
        return "read";
    }

    protected Class<?> getReaderInterface() {
        return EzyReader.class;
    }

    protected String makeMethodContent(EzyMethod readMethod) {
        Object[] paramNames = new String[readMethod.getParameterCount()];
        for (int i = 0; i < paramNames.length; ++i) {
            paramNames[i] = "arg" + i;
        }
        String paramNamesChain = EzyStrings.join((Object[])paramNames, (String)", ");
        return new EzyFunction(readMethod).body().append(new EzyInstruction("\t", "\n", false).append("try {")).append(new EzyInstruction("\t\t", "\n").append("return this." + this.getReadMethodName() + "$impl(" + paramNamesChain + ")")).append(new EzyInstruction("\t", "\n", false).append("} catch(").clazz(Exception.class).append(" e) {")).append(new EzyInstruction("\t\t", "\n\t}\n").append("throw new ").clazz(EzyReadValueException.class).bracketopen().clazz(this.clazz.getClazz(), true).append(", arg1, e").bracketclose()).function().toString();
    }

    protected void appendOutputObjectConstructor(EzyFunction.EzyBody methodBody) {
        Constructor constructor = this.clazz.getNoArgsDeclaredConstructor();
        List<Object> paramNames = Collections.emptyList();
        if (constructor == null) {
            paramNames = this.appendOutputObjectConstructorParams(methodBody);
        }
        EzyInstruction newOutputObjectInstruction = new EzyInstruction("", "", false).append("new ").clazz(this.clazz.getClazz(), false).bracketopen().append(String.join((CharSequence)", ", paramNames)).bracketclose();
        this.appendOutputObjectInstruction(methodBody, newOutputObjectInstruction);
    }

    protected List<String> appendOutputObjectConstructorParams(EzyFunction.EzyBody methodBody) {
        Constructor constructor = this.clazz.getMaxArgsDeclaredConstructor();
        ArrayList<String> keyList = new ArrayList<String>();
        List declaredFields = this.clazz.getDeclaredFields();
        for (EzyField field : declaredFields) {
            keyList.add(this.getKey((EzyReflectElement)field));
        }
        ArrayList<String> paramNames = new ArrayList<String>();
        Parameter[] constructorParameters = constructor.getParameters();
        for (int i = 0; i < constructor.getParameterCount(); ++i) {
            String paramName = "cparam" + i;
            Parameter parameter = constructorParameters[i];
            EzyInstruction constructorInstruction = new EzyInstruction("\t", "\n").variable(parameter.getType(), paramName).equal();
            EzyInstruction constructorValueInstruction = new EzyInstruction("", "", false);
            if (i >= keyList.size() || !parameter.getType().isAssignableFrom(((EzyField)declaredFields.get(i)).getType())) {
                constructorValueInstruction.defaultValue(parameter.getType());
            } else {
                this.appendConstructorParamValue(constructorValueInstruction, parameter, i, (EzyField)declaredFields.get(i), (String)keyList.get(i));
            }
            constructorInstruction.append(constructorValueInstruction.toString(false));
            methodBody.append(constructorInstruction);
            paramNames.add(paramName);
        }
        return paramNames;
    }

    protected void appendConstructorParamValue(EzyInstruction instruction, Parameter parameter, int parameterIndex, EzyField field, String key) {
    }

    protected void appendOutputObjectInstruction(EzyFunction.EzyBody methodBody, EzyInstruction newOutputObjectInstruction) {
        methodBody.append(new EzyInstruction("\t", "\n").variable(this.clazz.getClazz(), "object").equal().append(newOutputObjectInstruction.toString(false)));
    }

    protected abstract String getImplClassName();

    protected abstract String makeImplMethodContent(EzyMethod var1);

    protected void addPostReadMethods(EzyFunction.EzyBody methodBody) {
        for (EzyMethod method : this.postReadMethods) {
            EzyInstruction instruction = new EzyInstruction("\t", "\n").append("object").dot().append(method.getName()).brackets("");
            methodBody.append(instruction);
        }
    }

    protected EzyMethod getReadMethod() {
        return EzyMethod.builder().clazz(this.getReaderInterface()).methodName(this.getReadMethodName()).parameterTypes(this.getReaderMethodParameterTypes()).build();
    }

    protected Class[] getReaderMethodParameterTypes() {
        return new Class[]{EzyUnmarshaller.class, Object.class};
    }

    protected Class getReaderImplClass(EzyReflectElement element) {
        com.tvd12.ezyfox.binding.annotation.EzyReader rd = this.getReaderAnnotation(element);
        if (rd != null) {
            return rd.value();
        }
        if (element instanceof EzyField) {
            return null;
        }
        EzyField field = this.clazz.getField(this.getFieldName(element));
        return field == null ? null : this.getReaderImplClass((EzyReflectElement)field);
    }

    protected com.tvd12.ezyfox.binding.annotation.EzyReader getReaderAnnotation(EzyReflectElement element) {
        return (com.tvd12.ezyfox.binding.annotation.EzyReader)element.getAnnotation(com.tvd12.ezyfox.binding.annotation.EzyReader.class);
    }

    protected EzyInstruction wrapUnmarshalInstruction(EzyInstruction instruction, Class outType) {
        String value = instruction.toString();
        EzyInstruction answer = new EzyInstruction("", "", false);
        return answer.cast(outType, value);
    }

    protected Set<Class> getCommonGenericTypes() {
        return EzyTypes.COMMON_GENERIC_TYPES;
    }

    protected void printMethodContent(String methodContent) {
        if (this.isDebug()) {
            this.logger.debug("reader: method content \n{}", (Object)methodContent);
        }
    }

    protected abstract boolean isDebug();
}

