/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyfox.binding.impl;

import com.tvd12.ezyfox.binding.annotation.EzyArrayBinding;
import com.tvd12.ezyfox.binding.annotation.EzyIndex;
import com.tvd12.ezyfox.binding.impl.EzyAbstractElementsFetcher;
import com.tvd12.ezyfox.io.EzyMaps;
import com.tvd12.ezyfox.reflect.EzyAnnotatedElement;
import com.tvd12.ezyfox.reflect.EzyByFieldMethod;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyField;
import com.tvd12.ezyfox.reflect.EzyMethod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class EzyArrayElementsFetcher
extends EzyAbstractElementsFetcher {
    @Override
    protected List<Object> doGetElements(EzyClass clazz, int accessType) {
        String[] indexes = this.getIndexes(clazz);
        if (indexes.length > 0) {
            return this.getElementsByCustomIndexes(clazz, indexes);
        }
        if (accessType == 0) {
            return this.getAnnotatedElements(clazz);
        }
        return this.getElementsByNativeIndexes(clazz, accessType);
    }

    private List<Object> getElementsByNativeIndexes(EzyClass clazz, int accessType) {
        return this.getElementsByNativeIndexes(this.getFields(clazz, accessType), this.getMethods(clazz, accessType));
    }

    private List<Object> getElementsByNativeIndexes(List<EzyField> fields, List<? extends EzyMethod> methods) {
        ArrayList<Object> elements = new ArrayList<Object>();
        ArrayList<? extends EzyMethod> remainMethods = new ArrayList<EzyMethod>(methods);
        for (EzyField ezyField : fields) {
            this.logger.debug("scan field {}", (Object)ezyField.getName());
            EzyMethod method = (EzyMethod)this.methodsByFieldName.get(ezyField.getName());
            if (method != null) {
                if (this.isValidGenericMethod(method)) {
                    elements.add(method);
                } else {
                    elements.add(null);
                    this.logger.debug("unknown generic type of method {}, ignore it", (Object)method.getName());
                }
                remainMethods.remove(method);
                continue;
            }
            if (ezyField.isPublic()) {
                if (this.isValidGenericField(ezyField)) {
                    elements.add(ezyField);
                    continue;
                }
                this.logger.debug("unknown generic type of field {}, ignore it", (Object)ezyField.getName());
                elements.add(null);
                continue;
            }
            this.logger.debug("field {} has not getter/setter, ignore it", (Object)ezyField.getName());
        }
        for (EzyMethod ezyMethod : remainMethods) {
            this.logger.debug("scan method {}", (Object)ezyMethod.getName());
            if (this.isValidGenericMethod(ezyMethod)) {
                elements.add(ezyMethod);
                continue;
            }
            this.logger.debug("unknown generic type of method {}, ignore it", (Object)ezyMethod.getName());
        }
        return elements;
    }

    private List<Object> getElementsByCustomIndexes(EzyClass clazz, String[] indexes) {
        return this.getElementsByCustomIndexes(this.getFieldsByName(clazz), indexes);
    }

    /*
     * Enabled aggressive block sorting
     */
    private List<Object> getElementsByCustomIndexes(Map<String, EzyField> fieldsByName, String[] indexes) {
        ArrayList<Object> elements = new ArrayList<Object>();
        String[] stringArray = indexes;
        int n = stringArray.length;
        int n2 = 0;
        while (true) {
            block6: {
                String property;
                block10: {
                    block9: {
                        block7: {
                            EzyMethod method;
                            block8: {
                                if (n2 >= n) {
                                    return elements;
                                }
                                property = stringArray[n2];
                                this.logger.debug("scan property {}", (Object)property);
                                method = (EzyMethod)this.methodsByFieldName.get(property);
                                if (method == null) break block7;
                                if (this.isValidGenericMethod(method)) break block8;
                                this.logger.debug("unknown generic type of method {}, ignore it", (Object)method.getName());
                                break block9;
                            }
                            elements.add(method);
                            break block6;
                        }
                        this.logger.debug("has no getter/setter method map to property {}", (Object)property);
                    }
                    EzyField field = fieldsByName.get(property);
                    if (field == null) break block10;
                    if (!field.isPublic()) {
                        this.logger.debug("has no public field map to property {}", (Object)property);
                        break block6;
                    } else if (this.isValidGenericField(field)) {
                        elements.add(field);
                        break block6;
                    } else {
                        this.logger.debug("unknown generic type of field {}, ignore it", (Object)field.getName());
                    }
                    break block6;
                }
                elements.add(null);
                this.logger.debug("nothing map to property {}, ignore it", (Object)property);
            }
            ++n2;
        }
    }

    private List<Object> getAnnotatedElements(EzyClass clazz) {
        return this.getAnnotatedElements(clazz, this.getAnnotedFields(clazz), this.getAnnotatedMethods(clazz));
    }

    private List<Object> getAnnotatedElements(EzyClass clazz, List<EzyField> fields, List<? extends EzyMethod> methods) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (EzyField ezyField : fields) {
            this.logger.debug("scan field {}", (Object)ezyField.getName());
            EzyMethod method = (EzyMethod)this.methodsByFieldName.get(ezyField.getName());
            if (method != null) {
                if (!this.isValidGenericMethod(method)) {
                    this.logger.debug("unknown generic type of method {}, ignore it", (Object)method.getName());
                    continue;
                }
                elements.add(method);
                methods.remove(method);
                continue;
            }
            if (ezyField.isPublic()) {
                if (!this.isValidGenericField(ezyField)) {
                    this.logger.debug("unknown generic type of field {}, ignore it", (Object)ezyField.getName());
                    continue;
                }
                elements.add(ezyField);
                continue;
            }
            this.logger.debug("field {} has not getter/setter, ignore it", (Object)ezyField.getName());
        }
        for (EzyMethod ezyMethod : methods) {
            this.logger.debug("scan method {}", (Object)ezyMethod.getName());
            if (this.isValidGenericMethod(ezyMethod)) {
                elements.add(ezyMethod);
                continue;
            }
            this.logger.debug("unknown generic type of method {}, ignore it", (Object)ezyMethod.getName());
        }
        Object max = Collections.max(elements, Comparator.comparingInt(e -> this.getIndex(clazz, e)));
        int n = this.getIndex(clazz, max);
        Map elementsByIndex = EzyMaps.newHashMap(elements, e -> this.getIndex(clazz, e));
        ArrayList<Object> answer = new ArrayList<Object>();
        for (int index = 0; index <= n; ++index) {
            if (elementsByIndex.containsKey(index)) {
                answer.add(elementsByIndex.get(index));
                continue;
            }
            answer.add(null);
            this.logger.debug("has not property at index {}, so at this index value is null", (Object)index);
        }
        return answer;
    }

    private Map<String, EzyField> getFieldsByName(EzyClass clazz) {
        return EzyMaps.newHashMap((Collection)clazz.getFields(), EzyField::getName);
    }

    private List<EzyField> getAnnotedFields(EzyClass clazz) {
        return clazz.getFields(f -> f.isAnnotated(EzyIndex.class));
    }

    @Override
    protected boolean shouldAddAnnotatedMethod(EzyMethod method) {
        return method.isPublic() && method.isAnnotated(EzyIndex.class) && this.isValidAnnotatedMethod(method);
    }

    protected abstract boolean isValidAnnotatedMethod(EzyMethod var1);

    private String[] getIndexes(EzyClass clazz) {
        EzyArrayBinding ann = (EzyArrayBinding)clazz.getAnnotation(EzyArrayBinding.class);
        return ann != null ? ann.indexes() : new String[]{};
    }

    private int getIndex(EzyClass clazz, Object element) {
        EzyIndex index = (EzyIndex)((EzyAnnotatedElement)element).getAnnotation(EzyIndex.class);
        if (index != null) {
            return index.value();
        }
        return ((EzyIndex)clazz.getField(((EzyByFieldMethod)element).getFieldName()).getAnnotation(EzyIndex.class)).value();
    }
}

