/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezyhttp.client;

import com.tvd12.ezyfox.builder.EzyBuilder;
import com.tvd12.ezyfox.concurrent.EzyExecutors;
import com.tvd12.ezyfox.concurrent.EzyFuture;
import com.tvd12.ezyfox.concurrent.EzyFutureConcurrentHashMap;
import com.tvd12.ezyfox.concurrent.EzyFutureMap;
import com.tvd12.ezyfox.concurrent.EzyFutureTask;
import com.tvd12.ezyfox.util.EzyCloseable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfox.util.EzyProcessor;
import com.tvd12.ezyfox.util.EzyStartable;
import com.tvd12.ezyfox.util.EzyStoppable;
import com.tvd12.ezyhttp.client.HttpClient;
import com.tvd12.ezyhttp.client.callback.RequestCallback;
import com.tvd12.ezyhttp.client.concurrent.DownloadCancellationToken;
import com.tvd12.ezyhttp.client.concurrent.RequestFutureTask;
import com.tvd12.ezyhttp.client.concurrent.UploadCancellationToken;
import com.tvd12.ezyhttp.client.data.DownloadFileResult;
import com.tvd12.ezyhttp.client.exception.ClientNotActiveException;
import com.tvd12.ezyhttp.client.exception.RequestQueueFullException;
import com.tvd12.ezyhttp.client.request.DownloadRequest;
import com.tvd12.ezyhttp.client.request.Request;
import com.tvd12.ezyhttp.client.request.RequestQueue;
import com.tvd12.ezyhttp.client.request.UploadRequest;
import com.tvd12.ezyhttp.core.concurrent.HttpThreadFactory;
import com.tvd12.ezyhttp.core.response.ResponseEntity;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpClientProxy
extends EzyLoggable
implements EzyStartable,
EzyStoppable,
EzyCloseable {
    protected volatile boolean active;
    protected final HttpClient client;
    protected final int threadPoolSize;
    protected final AtomicBoolean started;
    protected final RequestQueue requestQueue;
    protected ExecutorService executorService;
    protected final EzyFutureMap<Request> futures;

    public HttpClientProxy(int threadPoolSize, int requestQueueCapacity, HttpClient client) {
        this(threadPoolSize, requestQueueCapacity, false, client);
    }

    public HttpClientProxy(int threadPoolSize, int requestQueueCapacity, boolean autoStart, HttpClient client) {
        this.client = client;
        this.threadPoolSize = threadPoolSize;
        this.started = new AtomicBoolean(false);
        this.futures = new EzyFutureConcurrentHashMap();
        this.requestQueue = new RequestQueue(requestQueueCapacity);
        this.doStart(autoStart);
    }

    private void doStart(boolean autoStart) {
        if (autoStart) {
            EzyProcessor.processWithException(this::start);
        }
    }

    public void start() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.active = true;
        this.executorService = EzyExecutors.newFixedThreadPool((int)this.threadPoolSize, (ThreadFactory)HttpThreadFactory.create((String)"client"));
        for (int i = 0; i < this.threadPoolSize; ++i) {
            this.executorService.execute(this::loop);
        }
    }

    public void stop() {
        EzyProcessor.processWithLogException(this::close);
    }

    public void close() {
        this.active = false;
        this.requestQueue.clear();
        Map undoneTasks = this.futures.clear();
        for (Request undoneRequest : undoneTasks.keySet()) {
            EzyFuture undoneTask = (EzyFuture)undoneTasks.get(undoneRequest);
            undoneTask.cancel("HttpClientProxy close, request to: " + undoneRequest.getURL() + " has cancelled");
        }
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    protected void loop() {
        while (this.active) {
            this.handleRequests();
        }
    }

    protected void handleRequests() {
        Request request = null;
        EzyFuture future = null;
        Exception exception = null;
        ResponseEntity response = null;
        try {
            request = this.requestQueue.take();
            future = this.futures.removeFuture((Object)request);
            response = this.client.request(request);
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            if (future != null) {
                if (exception != null) {
                    future.setException(exception);
                } else {
                    future.setResult(response);
                }
            } else if (exception != null) {
                this.logger.info("handled request: {} with exception, but there is no future", (Object)request, (Object)exception);
            } else {
                this.logger.info("handled request: {} with response: {}, but there is no future", (Object)request, (Object)response);
            }
        }
        catch (Throwable e) {
            this.logger.info("handle request result error", e);
        }
    }

    public <T> T call(Request request, int timeout) throws Exception {
        ResponseEntity entity = this.request(request, timeout);
        return this.client.getResponseBody(entity);
    }

    public ResponseEntity request(Request request, int timeout) throws Exception {
        EzyFutureTask future = new EzyFutureTask();
        this.futures.addFuture((Object)request, (EzyFuture)future);
        try {
            this.addRequest(request);
        }
        catch (Exception e) {
            this.futures.removeFuture((Object)request);
            throw e;
        }
        return (ResponseEntity)future.get((long)timeout);
    }

    public void fire(Request request, final RequestCallback callback) {
        this.execute(request, new RequestCallback<ResponseEntity>(){

            @Override
            public void onResponse(ResponseEntity response) {
                callback.onResponse(response.getBody());
            }

            @Override
            public void onException(Exception e) {
                callback.onException(e);
            }
        });
    }

    public void execute(Request request, RequestCallback<ResponseEntity> callback) {
        RequestFutureTask future = new RequestFutureTask(callback);
        this.futures.addFuture((Object)request, (EzyFuture)future);
        try {
            this.addRequest(request);
        }
        catch (Exception e) {
            this.futures.removeFuture((Object)request);
            throw e;
        }
    }

    protected void addRequest(Request request) {
        if (!this.active) {
            throw new ClientNotActiveException();
        }
        if (!this.requestQueue.add(request)) {
            throw new RequestQueueFullException(this.requestQueue.getCapacity());
        }
    }

    public String download(String fileURL, File storeLocation) throws Exception {
        return this.client.download(fileURL, storeLocation);
    }

    public String download(String fileURL, File storeLocation, DownloadCancellationToken cancellationToken) throws Exception {
        return this.client.download(fileURL, storeLocation, cancellationToken);
    }

    public String download(DownloadRequest request, File storeLocation) throws Exception {
        return this.client.download(request, storeLocation);
    }

    public String download(DownloadRequest request, File storeLocation, DownloadCancellationToken cancellationToken) throws Exception {
        return this.client.download(request, storeLocation, cancellationToken);
    }

    public void download(String fileURL, OutputStream outputStream) throws Exception {
        this.client.download(fileURL, outputStream);
    }

    public void download(String fileURL, OutputStream outputStream, DownloadCancellationToken cancellationToken) throws Exception {
        this.client.download(fileURL, outputStream, cancellationToken);
    }

    public void download(DownloadRequest request, OutputStream outputStream) throws Exception {
        this.client.download(request, outputStream);
    }

    public void download(DownloadRequest request, OutputStream outputStream, DownloadCancellationToken cancellationToken) throws Exception {
        this.client.download(request, outputStream, cancellationToken);
    }

    public DownloadFileResult download(String fileUrl, File storeLocation, String fileName) throws Exception {
        return this.client.download(fileUrl, storeLocation, fileName);
    }

    public DownloadFileResult download(String fileUrl, File storeLocation, String fileName, DownloadCancellationToken cancellationToken) throws Exception {
        return this.client.download(fileUrl, storeLocation, fileName, cancellationToken);
    }

    public DownloadFileResult download(DownloadRequest request, File storeLocation, String fileName) throws Exception {
        return this.client.download(request, storeLocation, fileName);
    }

    public DownloadFileResult download(DownloadRequest request, File storeLocation, String fileName, DownloadCancellationToken cancellationToken) throws Exception {
        return this.client.download(request, storeLocation, fileName, cancellationToken);
    }

    public <T> T callUpload(UploadRequest request) throws Exception {
        return this.client.callUpload(request);
    }

    public <T> T callUpload(UploadRequest request, UploadCancellationToken cancellationToken) throws Exception {
        return this.client.callUpload(request, cancellationToken);
    }

    public ResponseEntity upload(UploadRequest request) throws Exception {
        return this.client.upload(request);
    }

    public ResponseEntity upload(UploadRequest request, UploadCancellationToken cancellationToken) throws Exception {
        return this.client.upload(request, cancellationToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements EzyBuilder<HttpClientProxy> {
        protected boolean autoStart;
        protected int threadPoolSize = Runtime.getRuntime().availableProcessors() * 2;
        protected int requestQueueCapacity = 10000;
        protected final HttpClient.Builder clientBuilder = HttpClient.builder();

        public Builder autoStart(boolean autoStart) {
            this.autoStart = autoStart;
            return this;
        }

        public Builder readTimeout(int readTimeout) {
            this.clientBuilder.readTimeout(readTimeout);
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            this.clientBuilder.connectTimeout(connectTimeout);
            return this;
        }

        public Builder setStringConverter(Object converter) {
            this.clientBuilder.setStringConverter(converter);
            return this;
        }

        public Builder addBodyConverter(Object converter) {
            this.clientBuilder.addBodyConverter(converter);
            return this;
        }

        public Builder addBodyConverter(String contentType, Object converter) {
            this.clientBuilder.addBodyConverter(contentType, converter);
            return this;
        }

        public Builder addBodyConverters(List<?> converters) {
            this.clientBuilder.addBodyConverters(converters);
            return this;
        }

        public Builder addBodyConverters(Map<String, Object> converterByContentType) {
            this.clientBuilder.addBodyConverters(converterByContentType);
            return this;
        }

        public Builder threadPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public Builder requestQueueCapacity(int requestQueueCapacity) {
            this.requestQueueCapacity = requestQueueCapacity;
            return this;
        }

        public HttpClientProxy build() {
            return new HttpClientProxy(this.threadPoolSize, this.requestQueueCapacity, this.autoStart, this.clientBuilder.build());
        }
    }
}

