/*
 * Decompiled with CFR 0.152.
 */
package org.youngmonkeys.ezyplatform.socket;

import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.mapping.jaxb.EzySimpleXmlMapper;
import com.tvd12.ezyfox.mapping.jaxb.EzyXmlReader;
import com.tvd12.ezyfox.util.EzyInitable;
import com.tvd12.ezyfox.util.EzyLoggable;
import com.tvd12.ezyfoxserver.constant.EzyEventType;
import com.tvd12.ezyfoxserver.setting.EzyAppSetting;
import com.tvd12.ezyfoxserver.setting.EzyAppsSetting;
import com.tvd12.ezyfoxserver.setting.EzyEventControllerSettingBuilder;
import com.tvd12.ezyfoxserver.setting.EzyHomePathAware;
import com.tvd12.ezyfoxserver.setting.EzyPluginSetting;
import com.tvd12.ezyfoxserver.setting.EzyPluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySettingsDecorator;
import com.tvd12.ezyfoxserver.setting.EzySimpleAppSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleEventControllersSetting;
import com.tvd12.ezyfoxserver.setting.EzySimplePluginSetting;
import com.tvd12.ezyfoxserver.setting.EzySimplePluginsSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleSettings;
import com.tvd12.ezyfoxserver.setting.EzySimpleUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleWebSocketSetting;
import com.tvd12.ezyfoxserver.setting.EzySimpleZoneSetting;
import com.tvd12.ezyfoxserver.setting.EzyUserManagementSetting;
import com.tvd12.ezyfoxserver.setting.EzyZoneSetting;
import com.tvd12.properties.file.reader.BaseFileReader;
import com.tvd12.properties.file.reader.FileReader;
import java.io.File;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.youngmonkeys.ezyplatform.entity.ModuleType;
import org.youngmonkeys.ezyplatform.manager.FileSystemManager;
import org.youngmonkeys.ezyplatform.socket.controller.SocketGlobalServerReadyEventHandler;
import org.youngmonkeys.ezyplatform.socket.entry.DefaultPluginEntryLoader;
import org.youngmonkeys.ezyplatform.socket.settings.ModuleMetadata;
import org.youngmonkeys.ezyplatform.socket.settings.ModuleProperties;
import org.youngmonkeys.ezyplatform.socket.settings.SocketModuleMetadataReader;
import org.youngmonkeys.ezyplatform.socket.settings.SocketModulePropertiesReader;

public class SocketSettingsDecorator
extends EzyLoggable
implements EzySettingsDecorator {
    private final FileReader fileReader = new BaseFileReader();
    private final SocketModuleMetadataReader moduleMetadataReader = new SocketModuleMetadataReader();
    private final SocketModulePropertiesReader modulePropertiesReader = new SocketModulePropertiesReader();
    private static final String FILE_CONFIG_SOCKET = "socket/settings/config.properties";
    private static final String PROPERTY_KEY_WS_SSL_ENABLE = "websocket.ssl.enable";

    public void decorate(String homePath, EzySimpleSettings settings) {
        String platformHomePath = Paths.get(homePath, new String[0]).toAbsolutePath().getParent().toString();
        this.setProperties(platformHomePath, settings);
        this.addEventListeners(settings);
        this.registerPlugins(platformHomePath, homePath, settings);
        this.registerApps(platformHomePath, homePath, settings);
        this.addDefaultPluginToZonesIfAbsent(homePath, settings);
    }

    private void setProperties(String platformHomePath, EzySimpleSettings settings) {
        Properties properties = this.fileReader.read(Paths.get(platformHomePath, FILE_CONFIG_SOCKET).toFile());
        EzySimpleWebSocketSetting webSocketSetting = settings.getWebsocket();
        webSocketSetting.setSslActive(Boolean.parseBoolean(properties.getOrDefault((Object)PROPERTY_KEY_WS_SSL_ENABLE, Boolean.FALSE).toString()));
    }

    private void addEventListeners(EzySimpleSettings settings) {
        EzySimpleEventControllersSetting controllers = settings.getEventControllers();
        controllers.setItem(new EzyEventControllerSettingBuilder().eventType(EzyEventType.SERVER_READY).controller(SocketGlobalServerReadyEventHandler.class).build());
    }

    private void registerPlugins(String platformHomePath, String homePath, EzySimpleSettings settings) {
        EzyXmlReader xmlReader = this.newXmlReader();
        Map<String, ModuleMetadata> pluginMetadataMap = this.moduleMetadataReader.readModuleMetadataMap(platformHomePath, ModuleType.SOCKET_PLUGIN);
        for (File pluginFolder : this.getPluginFolders(homePath)) {
            EzySimplePluginSetting plugin;
            ModuleMetadata moduleMetadata;
            String pluginName = pluginFolder.getName();
            if (!pluginName.equals("socket-monitor") && ((moduleMetadata = pluginMetadataMap.get(pluginName)) == null || !moduleMetadata.isActive())) continue;
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(pluginFolder);
            String zoneName = moduleProperties.getZoneName();
            EzySimpleZoneSetting zoneSetting = this.getZoneSetting(settings, zoneName);
            if (zoneSetting == null) {
                zoneSetting = this.readZoneSetting(xmlReader, pluginFolder.toString(), moduleProperties.getZoneSettingFile());
                this.postReadZoneSetting(homePath, (EzyZoneSetting)zoneSetting);
                zoneSetting.setName(zoneName);
                zoneSetting.init();
                settings.addZone(zoneSetting);
            }
            if ((plugin = this.getPluginSetting(zoneSetting, pluginName)) != null) continue;
            plugin = new EzySimplePluginSetting();
            plugin.setName(pluginName);
            plugin.setFolder(pluginName);
            plugin.setEntryLoader(this.getEntryLoader(moduleProperties));
            plugin.setConfigFile(moduleProperties.getConfigFile());
            plugin.setPackageName(moduleProperties.getPackageName());
            plugin.setPriority(moduleProperties.getPriority());
            EzySimplePluginSetting.EzySimpleListenEvents listenEvents = plugin.getListenEvents();
            for (String listenEvent : moduleProperties.getListenEvents()) {
                listenEvents.setEvent(listenEvent);
            }
            plugin.setThreadPoolSize(moduleProperties.getThreadPoolSize());
            plugin.setHomePath(homePath);
            zoneSetting.getPlugins().setItem(plugin);
            this.logger.info("zone: {} added plugin: {}", (Object)zoneName, (Object)pluginName);
        }
    }

    private void registerApps(String platformHomePath, String homePath, EzySimpleSettings settings) {
        Map<String, ModuleMetadata> appMetadataMap = this.moduleMetadataReader.readModuleMetadataMap(platformHomePath, ModuleType.SOCKET_APP);
        for (File appFolder : this.getAppFolders(homePath)) {
            String appName = appFolder.getName();
            ModuleMetadata moduleMetadata = appMetadataMap.get(appName);
            if (moduleMetadata == null || !moduleMetadata.isActive()) continue;
            ModuleProperties moduleProperties = this.modulePropertiesReader.read(appFolder);
            String zoneName = moduleProperties.getZoneName();
            EzySimpleZoneSetting zoneSetting = this.getZoneSetting(settings, zoneName);
            if (zoneSetting == null) {
                this.logger.warn("can not start: {} app due to zone: {} not found", (Object)zoneName, (Object)appName);
                continue;
            }
            EzySimpleAppSetting app = this.getAppSetting(zoneSetting, appName);
            if (app != null) continue;
            app = new EzySimpleAppSetting();
            app.setName(appName);
            app.setFolder(appName);
            app.setEntryLoader(this.getEntryLoader(moduleProperties));
            app.setConfigFile(moduleProperties.getConfigFile());
            app.setPackageName(moduleProperties.getPackageName());
            app.setMaxUsers(moduleProperties.getMaxUsers());
            app.setThreadPoolSize(moduleProperties.getThreadPoolSize());
            app.setHomePath(homePath);
            zoneSetting.getApplications().setItem(app);
            this.logger.info("zone: {} added app: {}", (Object)zoneName, (Object)appName);
        }
    }

    private void addDefaultPluginToZonesIfAbsent(String homePath, EzySimpleSettings settings) {
        for (String zoneName : settings.getZoneNames()) {
            EzySimpleZoneSetting zone = settings.getZoneByName(zoneName);
            EzySimplePluginsSetting plugins = zone.getPlugins();
            if (plugins.getSize() > 0) continue;
            EzySimplePluginSetting plugin = new EzySimplePluginSetting();
            plugin.setName("default");
            plugin.setFolder("default");
            plugin.setEntryLoader(DefaultPluginEntryLoader.class);
            plugin.setPackageName("org.youngmonkeys.ezyplatform.socket");
            plugin.setPriority(Integer.MAX_VALUE);
            EzySimplePluginSetting.EzySimpleListenEvents listenEvents = plugin.getListenEvents();
            listenEvents.setEvent("USER_LOGIN");
            plugin.setHomePath(homePath);
            plugins.setItem(plugin);
            this.logger.info("zone: {} added plugin: default", (Object)zoneName);
        }
    }

    private String getEntryLoader(ModuleProperties properties) {
        String packageName = properties.getPackageName();
        String entryLoader = properties.getEntryLoader();
        if (packageName != null && entryLoader != null) {
            String entryLoaderFullName = entryLoader.contains(packageName) ? entryLoader : packageName + "." + entryLoader;
            try {
                Class.forName(entryLoaderFullName);
                entryLoader = entryLoaderFullName;
            }
            catch (Throwable e) {
                this.logger.info("can not get entry loader of packageName: {}, entryLoader: {} due to: {} ({})", new Object[]{packageName, entryLoader, e.getClass(), e.getMessage()});
            }
        }
        return entryLoader;
    }

    private EzySimpleZoneSetting getZoneSetting(EzySimpleSettings settings, String zoneName) {
        try {
            return settings.getZoneByName(zoneName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EzySimplePluginSetting getPluginSetting(EzySimpleZoneSetting zoneSetting, String pluginName) {
        try {
            return zoneSetting.getPluginByName(pluginName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private EzySimpleAppSetting getAppSetting(EzySimpleZoneSetting zoneSetting, String appName) {
        try {
            return zoneSetting.getAppByName(appName);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<File> getPluginFolders(String homePath) {
        return FileSystemManager.getModuleFolders((String)homePath, (String)"plugins");
    }

    private List<File> getAppFolders(String homePath) {
        return FileSystemManager.getModuleFolders((String)homePath, (String)"apps");
    }

    protected EzyXmlReader newXmlReader() {
        return EzySimpleXmlMapper.builder().classLoader(this.getClassLoader()).contextPath("com.tvd12.ezyfoxserver").build();
    }

    protected ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    protected EzySimpleZoneSetting readZoneSetting(EzyXmlReader xmlReader, String pluginFolder, String zoneSettingFile) {
        File file;
        String settingFile = null;
        if (EzyStrings.isNotBlank((String)zoneSettingFile) && !(file = new File(settingFile = Paths.get(pluginFolder, zoneSettingFile).toString())).exists()) {
            settingFile = null;
        }
        if (settingFile == null) {
            EzySimpleZoneSetting zoneSetting = new EzySimpleZoneSetting();
            zoneSetting.setMaxUsers(1000000);
            EzySimpleUserManagementSetting userManagementSetting = zoneSetting.getUserManagement();
            userManagementSetting.setAllowGuestLogin(false);
            userManagementSetting.setMaxSessionPerUser(30);
            userManagementSetting.setUserNamePattern(".*");
            userManagementSetting.setUserMaxIdleTimeInSecond(15L);
            return zoneSetting;
        }
        return (EzySimpleZoneSetting)xmlReader.read(settingFile, EzySimpleZoneSetting.class);
    }

    protected void postReadZoneSetting(String homePath, EzyZoneSetting zoneSetting) {
        this.updatePluginsSetting(homePath, zoneSetting.getPlugins());
        this.updateAppsSetting(homePath, zoneSetting.getApplications());
        this.updateUserManagementSetting(zoneSetting.getUserManagement());
    }

    protected void updateAppsSetting(String homePath, EzyAppsSetting apps) {
        for (EzyAppSetting app : apps.getApps()) {
            ((EzyHomePathAware)app).setHomePath(homePath);
        }
    }

    protected void updatePluginsSetting(String homePath, EzyPluginsSetting plugins) {
        for (EzyPluginSetting plugin : plugins.getPlugins()) {
            ((EzyHomePathAware)plugin).setHomePath(homePath);
        }
    }

    protected void updateUserManagementSetting(EzyUserManagementSetting setting) {
        ((EzyInitable)setting).init();
    }
}

