/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database;

import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.database.converter.EzyResultDeserializer;
import com.tvd12.ezydata.database.converter.EzyResultDeserializers;
import com.tvd12.ezydata.database.query.EzyQueryEntity;
import com.tvd12.ezydata.database.query.EzyQueryManager;
import com.tvd12.ezydata.database.query.EzyQueryManagerFetcher;
import com.tvd12.ezydata.database.util.EzyDatabaseRepositories;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EzySimpleDatabaseContext
implements EzyDatabaseContext,
EzyQueryManagerFetcher {
    protected final Map<Class, Object> repositories = new HashMap<Class, Object>();
    protected final Map<String, Object> repositoriesByName = new HashMap<String, Object>();
    protected EzyQueryManager queryManager;
    protected EzyResultDeserializers deserializers;

    protected EzySimpleDatabaseContext() {
    }

    @Override
    public EzyQueryEntity getQuery(String queryName) {
        EzyQueryEntity query = this.queryManager.getQuery(queryName);
        if (query == null) {
            throw new IllegalArgumentException("has no query with name: " + queryName);
        }
        return query;
    }

    @Override
    public Object deserializeResult(Object result, Class<?> resultType) {
        return this.deserializers.deserialize(result, resultType);
    }

    @Override
    public List deserializeResultList(Object result, Class<?> resultItemType) {
        ArrayList<Object> answer = new ArrayList<Object>();
        for (Object item : (Iterable)result) {
            Object data = this.deserializers.deserialize(item, resultItemType);
            answer.add(data);
        }
        return answer;
    }

    @Override
    public <T> T getRepository(String name) {
        Object repo = this.repositoriesByName.get(name);
        if (repo == null) {
            throw new IllegalArgumentException("has no repository with name: " + name);
        }
        return (T)repo;
    }

    @Override
    public <T> T getRepository(Class<T> repoType) {
        Object repo = this.repositories.get(repoType);
        if (repo == null) {
            throw new IllegalArgumentException("has no repository with type: " + repoType.getName());
        }
        return (T)repo;
    }

    @Override
    public Map<Class, Object> getRepositories() {
        return new HashMap<Class, Object>(this.repositories);
    }

    public void setRepositories(Map<Class, Object> repos) {
        for (Class repoType : repos.keySet()) {
            Object repo = repos.get(repoType);
            String repoName = EzyDatabaseRepositories.getRepoName(repoType);
            this.repositories.put(repoType, repo);
            this.repositoriesByName.put(repoName, repo);
        }
    }

    @Override
    public Map<String, Object> getRepositoriesByName() {
        return new HashMap<String, Object>(this.repositoriesByName);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Map<String, EzyQueryEntity> queries = this.queryManager.getQueries();
        builder.append("list of queries:");
        if (queries.isEmpty()) {
            builder.append(" empty");
        } else {
            builder.append(" ").append(queries.size());
        }
        for (EzyQueryEntity query : queries.values()) {
            builder.append("\n");
            builder.append(query.getName()).append("=").append(query.getValue());
        }
        builder.append("\n\nlist of repositories:");
        if (this.repositoriesByName.isEmpty()) {
            builder.append(" empty");
        } else {
            builder.append(" ").append(this.repositoriesByName.size());
        }
        for (String repoName : this.repositoriesByName.keySet()) {
            Object repo = this.repositoriesByName.get(repoName);
            builder.append("\n");
            builder.append(repoName).append("=").append(repo.getClass().getName());
        }
        Map<Class<?>, EzyResultDeserializer> resultDeserializers = this.deserializers.getDeserializers();
        builder.append("\n\nlist of result deserializers:").append(" ").append(resultDeserializers.size());
        for (Class<?> resultType : resultDeserializers.keySet()) {
            builder.append("\n");
            EzyResultDeserializer deserializer = resultDeserializers.get(resultType);
            builder.append(resultType.getName()).append("=").append(deserializer.getClass().getName());
        }
        return builder.toString();
    }

    public void setQueryManager(EzyQueryManager queryManager) {
        this.queryManager = queryManager;
    }

    public void setDeserializers(EzyResultDeserializers deserializers) {
        this.deserializers = deserializers;
    }

    @Override
    public EzyQueryManager getQueryManager() {
        return this.queryManager;
    }
}

