/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.ezydata.database.bean;

import com.tvd12.ezydata.database.EzyDatabaseContext;
import com.tvd12.ezydata.database.EzyDatabaseContextAware;
import com.tvd12.ezydata.database.EzyDatabaseRepository;
import com.tvd12.ezydata.database.EzyDatabaseRepositoryWrapper;
import com.tvd12.ezydata.database.query.EzyQueryEntity;
import com.tvd12.ezydata.database.query.EzyQueryMethod;
import com.tvd12.ezydata.database.query.EzyQueryMethodConverter;
import com.tvd12.ezydata.database.query.EzyQueryRegister;
import com.tvd12.ezydata.database.query.EzyQueryString;
import com.tvd12.ezyfox.asm.EzyFunction;
import com.tvd12.ezyfox.asm.EzyInstruction;
import com.tvd12.ezyfox.database.annotation.EzyQuery;
import com.tvd12.ezyfox.io.EzyStrings;
import com.tvd12.ezyfox.reflect.EzyClass;
import com.tvd12.ezyfox.reflect.EzyGenerics;
import com.tvd12.ezyfox.reflect.EzyMethod;
import com.tvd12.ezyfox.reflect.EzyMethods;
import com.tvd12.ezyfox.util.EzyLoggable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;

public abstract class EzyAbstractRepositoryImplementer
extends EzyLoggable {
    protected static boolean debug;
    protected final EzyClass clazz;
    protected Class<?> idType;
    protected Class<?> entityType;
    protected EzyQueryRegister queryManager;
    protected EzyQueryMethodConverter queryMethodConverter;
    protected EzyDatabaseRepositoryWrapper repositoryWrapper;
    protected static final AtomicInteger COUNT;

    public EzyAbstractRepositoryImplementer(Class<?> clazz) {
        this(new EzyClass(clazz));
    }

    public EzyAbstractRepositoryImplementer(EzyClass clazz) {
        this.clazz = clazz;
    }

    public Object implement(Object template) {
        try {
            return this.doImplement(template);
        }
        catch (Exception e) {
            throw new IllegalStateException("error on repo interface: " + this.clazz.getName(), e);
        }
    }

    protected Object doImplement(Object template) throws Exception {
        Class[] idAndEntityTypes = this.getIdAndEntityTypes();
        this.idType = idAndEntityTypes[0];
        this.entityType = idAndEntityTypes[1];
        ClassPool pool = ClassPool.getDefault();
        String implClassName = this.getImplClassName();
        CtClass implClass = pool.makeClass(implClassName);
        EzyClass superClass = new EzyClass(this.getSuperClass());
        implClass.setSuperclass(pool.get(superClass.getName()));
        for (EzyMethod method : this.getAbstractMethods()) {
            this.registerQuery(method);
            String methodContent = this.makeAbstractMethodContent(method);
            this.printMethodContent(methodContent);
            implClass.addMethod(CtNewMethod.make((String)methodContent, (CtClass)implClass));
        }
        String getEntityTypeMethodContent = this.makeGetEntityTypeMethodContent(this.entityType);
        this.printMethodContent(getEntityTypeMethodContent);
        implClass.addMethod(CtNewMethod.make((String)getEntityTypeMethodContent, (CtClass)implClass));
        implClass.setInterfaces(new CtClass[]{pool.get(this.clazz.getName())});
        Class answerClass = implClass.toClass();
        implClass.detach();
        Object repo = answerClass.newInstance();
        if (template instanceof EzyDatabaseContext && repo instanceof EzyDatabaseContextAware) {
            ((EzyDatabaseContextAware)repo).setDatabaseContext((EzyDatabaseContext)template);
        }
        this.setRepoComponent(repo, template);
        return this.repositoryWrapper.wrap(repo);
    }

    protected void setRepoComponent(Object repo, Object template) {
    }

    protected Collection<EzyMethod> getAbstractMethods() {
        return this.clazz.getDistinctMethods(this::isAbstractMethod);
    }

    protected boolean isAbstractMethod(EzyMethod method) {
        if (method.isAnnotated(EzyQuery.class)) {
            return true;
        }
        return this.isAutoImplementMethod(method);
    }

    protected boolean isAutoImplementMethod(EzyMethod method) {
        for (EzyMethod defMethod : EzyDatabaseRepository.CLASS.getMethods()) {
            if (method.equals((Object)defMethod)) {
                return false;
            }
            if (!EzyMethods.isOverriddenMethod((EzyMethod)method, (EzyMethod)defMethod)) continue;
            return false;
        }
        return true;
    }

    protected void registerQuery(EzyMethod method) {
        if (this.queryManager == null) {
            return;
        }
        EzyQuery queryAnno = (EzyQuery)method.getAnnotation(EzyQuery.class);
        if (queryAnno == null) {
            return;
        }
        String queryValue = queryAnno.value();
        if (EzyStrings.isNoContent((String)queryValue)) {
            return;
        }
        String queryName = queryAnno.name();
        if (EzyStrings.isNoContent((String)queryName)) {
            queryName = method.toString();
        }
        EzyQueryEntity queryEntity = EzyQueryEntity.builder().name(queryName).type(queryAnno.type()).value(queryValue).nativeQuery(queryAnno.nativeQuery()).resultType(queryAnno.resultType()).build();
        this.queryManager.addQuery(queryEntity);
    }

    protected String makeAbstractMethodContent(EzyMethod method) {
        EzyFunction.EzyBody body = new EzyFunction(method).body();
        return body.function().toString();
    }

    protected EzyQueryString getQueryString(EzyMethod method) {
        EzyQuery anno = (EzyQuery)method.getAnnotation(EzyQuery.class);
        if (anno != null) {
            return this.getQueryString(method, anno);
        }
        return this.convertQueryMethodToQueryString(method);
    }

    protected EzyQueryString getQueryString(EzyMethod method, EzyQuery queryAnnotation) {
        String queryString = queryAnnotation.value();
        boolean nativeQuery = queryAnnotation.nativeQuery();
        if (EzyStrings.isNoContent((String)queryString)) {
            String queryName = queryAnnotation.name();
            if (EzyStrings.isNoContent((String)queryName)) {
                throw new IllegalArgumentException("query name can not be null on method: " + method.getName());
            }
            EzyQueryEntity query = this.queryManager.getQuery(queryName);
            if (query == null) {
                throw new IllegalArgumentException("not found query with name: " + queryName + " on method: " + method.getName());
            }
            queryString = query.getValue();
            nativeQuery = query.isNativeQuery();
        }
        return new EzyQueryString(queryString, nativeQuery);
    }

    protected EzyQueryString convertQueryMethodToQueryString(EzyMethod method) {
        EzyQueryMethod queryMethod = new EzyQueryMethod(method);
        return new EzyQueryString(this.queryMethodConverter.toQueryString(this.entityType, queryMethod));
    }

    protected boolean isPaginationMethod(EzyMethod method) {
        return EzyQueryMethod.isPaginationMethod(method);
    }

    protected Class<?> getResultType(EzyMethod method) {
        Class resultType = Object.class;
        EzyQuery anno = (EzyQuery)method.getAnnotation(EzyQuery.class);
        if (anno != null) {
            resultType = anno.resultType();
        }
        if (resultType == Object.class && Iterable.class.isAssignableFrom(resultType = method.getReturnType())) {
            try {
                resultType = EzyGenerics.getOneGenericClassArgument((Type)method.getGenericReturnType());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return resultType;
    }

    protected String makeGetEntityTypeMethodContent(Class entityType) {
        return new EzyFunction(this.getEntityTypeMethod()).body().append(new EzyInstruction("\t", "\n").answer().clazz(entityType, true)).function().toString();
    }

    protected EzyMethod getEntityTypeMethod() {
        return new EzyMethod(EzyMethods.getMethod(this.getSuperClass(), (String)"getEntityType", (Class[])new Class[0]));
    }

    protected abstract Class<?> getSuperClass();

    protected String getImplClassName() {
        return this.clazz.getName() + "$EzyDatabaseRepository$EzyAutoImpl$" + COUNT.incrementAndGet();
    }

    protected Class[] getIdAndEntityTypes() {
        return EzyGenerics.getGenericInterfacesArguments((Class)this.clazz.getClazz(), this.getBaseRepositoryInterface(), (int)2);
    }

    protected Class<?> getBaseRepositoryInterface() {
        return EzyDatabaseRepository.class;
    }

    protected void printMethodContent(String methodContent) {
        if (debug) {
            this.logger.info("method content \n{}", (Object)methodContent);
        }
    }

    public static void setDebug(boolean debug) {
        EzyAbstractRepositoryImplementer.debug = debug;
    }

    public void setQueryManager(EzyQueryRegister queryManager) {
        this.queryManager = queryManager;
    }

    public void setQueryMethodConverter(EzyQueryMethodConverter queryMethodConverter) {
        this.queryMethodConverter = queryMethodConverter;
    }

    public void setRepositoryWrapper(EzyDatabaseRepositoryWrapper repositoryWrapper) {
        this.repositoryWrapper = repositoryWrapper;
    }

    static {
        COUNT = new AtomicInteger(0);
    }
}

