/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections;

import com.tvd12.reflections.Configuration;
import com.tvd12.reflections.ReflectionUtils;
import com.tvd12.reflections.ReflectionsException;
import com.tvd12.reflections.Store;
import com.tvd12.reflections.scanners.FieldAnnotationsScanner;
import com.tvd12.reflections.scanners.MemberUsageScanner;
import com.tvd12.reflections.scanners.MethodAnnotationsScanner;
import com.tvd12.reflections.scanners.MethodParameterNamesScanner;
import com.tvd12.reflections.scanners.MethodParameterScanner;
import com.tvd12.reflections.scanners.ResourcesScanner;
import com.tvd12.reflections.scanners.Scanner;
import com.tvd12.reflections.scanners.SubTypesScanner;
import com.tvd12.reflections.scanners.TypeAnnotationsScanner;
import com.tvd12.reflections.serializers.Serializer;
import com.tvd12.reflections.serializers.XmlSerializer;
import com.tvd12.reflections.util.ClasspathHelper;
import com.tvd12.reflections.util.ConfigurationBuilder;
import com.tvd12.reflections.util.FilterBuilder;
import com.tvd12.reflections.util.HashMultimap;
import com.tvd12.reflections.util.Iterables;
import com.tvd12.reflections.util.Joiner;
import com.tvd12.reflections.util.Lists;
import com.tvd12.reflections.util.Multimap;
import com.tvd12.reflections.util.Predicates;
import com.tvd12.reflections.util.Sets;
import com.tvd12.reflections.util.Utils;
import com.tvd12.reflections.vfs.Vfs;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.slf4j.Logger;

public class Reflections {
    @Nullable
    public static Logger log = Utils.findLogger(Reflections.class);
    protected final transient Configuration configuration;
    protected Store store;

    public Reflections(Configuration configuration) {
        this.configuration = configuration;
        this.store = new Store(configuration);
        if (configuration.getScanners() != null && !configuration.getScanners().isEmpty()) {
            for (Scanner scanner : configuration.getScanners()) {
                scanner.setConfiguration(configuration);
                scanner.setStore(this.store.getOrCreate(Utils.index(scanner.getClass())));
            }
            this.scan();
            if (configuration.shouldExpandSuperTypes()) {
                this.expandSuperTypes();
            }
        }
    }

    public Reflections(String prefix, Scanner ... scanners) {
        this(new Object[]{prefix, scanners});
    }

    public Reflections(Object ... params) {
        this(ConfigurationBuilder.build(params));
    }

    protected Reflections() {
        this.configuration = new ConfigurationBuilder();
        this.store = new Store(this.configuration);
    }

    protected void scan() {
        if (this.configuration.getUrls() == null || this.configuration.getUrls().isEmpty()) {
            if (log != null) {
                log.warn("given scan urls are empty. set urls in the configuration");
            }
            return;
        }
        if (log != null && log.isDebugEnabled()) {
            log.debug("going to scan these urls:\n{}", (Object)Joiner.on("\n").join(this.configuration.getUrls()));
        }
        long time = System.currentTimeMillis();
        int scannedUrls = 0;
        ExecutorService executorService = this.configuration.getExecutorService();
        List<Future> futures = Lists.newArrayList(new Future[0]);
        for (final URL url : this.configuration.getUrls()) {
            try {
                if (executorService != null) {
                    futures.add(executorService.submit(new Runnable(){

                        @Override
                        public void run() {
                            if (log != null) {
                                log.debug("[{}] scanning {}", (Object)Thread.currentThread().toString(), (Object)url);
                            }
                            Reflections.this.scan(url);
                        }
                    }));
                } else {
                    this.scan(url);
                }
                ++scannedUrls;
            }
            catch (ReflectionsException e) {
                if (log == null) continue;
                log.debug("could not create Vfs.Dir from url. ignoring the exception and continuing", (Throwable)e);
            }
        }
        if (executorService != null) {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        time = System.currentTimeMillis() - time;
        if (executorService != null) {
            executorService.shutdown();
        }
        if (log != null) {
            int keys = 0;
            int values = 0;
            for (String index : this.store.keySet()) {
                keys += this.store.get(index).keySet().size();
                values += this.store.get(index).size();
            }
            log.debug(String.format("Reflections took %d ms to scan %d urls, producing %d keys and %d values %s", time, scannedUrls, keys, values, executorService != null && executorService instanceof ThreadPoolExecutor ? String.format("[using %d cores]", ((ThreadPoolExecutor)executorService).getMaximumPoolSize()) : ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scan(URL url) {
        try (Vfs.Dir dir = Vfs.fromURL(url);){
            for (Vfs.File file : dir.getFiles()) {
                Predicate<String> inputsFilter = this.configuration.getInputsFilter();
                String path = file.getRelativePath();
                String fqn = path.replace('/', '.');
                if (inputsFilter != null && !inputsFilter.test(path) && !inputsFilter.test(fqn)) continue;
                Object classObject = null;
                for (Scanner scanner : this.configuration.getScanners()) {
                    try {
                        if (!scanner.acceptsInput(path) && !scanner.acceptsInput(fqn)) continue;
                        classObject = scanner.scan(file, classObject);
                    }
                    catch (Exception e) {
                        if (log == null) continue;
                        log.debug("could not scan file {} in url {} with scanner {}", new Object[]{file.getRelativePath(), url.toExternalForm(), scanner.getClass().getSimpleName(), e});
                    }
                }
            }
        }
    }

    public static Reflections collect() {
        return Reflections.collect("META-INF/reflections/", new FilterBuilder().include(".*-reflections.xml"), new Serializer[0]);
    }

    public static Reflections collect(String packagePrefix, Predicate<String> resourceNameFilter, Serializer ... optionalSerializer) {
        XmlSerializer serializer = optionalSerializer != null && optionalSerializer.length == 1 ? optionalSerializer[0] : new XmlSerializer();
        Collection<URL> urls = ClasspathHelper.forPackage(packagePrefix, new ClassLoader[0]);
        if (urls.isEmpty()) {
            return null;
        }
        long start = System.currentTimeMillis();
        Reflections reflections = new Reflections();
        Iterable<Vfs.File> files = Vfs.findFiles(urls, packagePrefix, resourceNameFilter);
        for (Vfs.File file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.openInputStream();
                reflections.merge(serializer.read(inputStream));
            }
            catch (IOException e) {
                throw new ReflectionsException("could not merge " + file, e);
            }
            finally {
                Utils.close(inputStream);
            }
        }
        if (log != null) {
            Store store = reflections.getStore();
            int keys = 0;
            int values = 0;
            for (String index : store.keySet()) {
                keys += store.get(index).keySet().size();
                values += store.get(index).size();
            }
            log.debug(String.format("Reflections took %d ms to collect %d url%s, producing %d keys and %d values [%s]", System.currentTimeMillis() - start, urls.size(), urls.size() > 1 ? "s" : "", keys, values, Joiner.on(", ").join(urls)));
        }
        return reflections;
    }

    public Reflections collect(InputStream inputStream) {
        try {
            this.merge(this.configuration.getSerializer().read(inputStream));
            if (log != null) {
                log.debug("Reflections collected metadata from input stream using serializer " + this.configuration.getSerializer().getClass().getName());
            }
        }
        catch (Exception ex) {
            throw new ReflectionsException("could not merge input stream", ex);
        }
        return this;
    }

    public Reflections collect(File file) {
        Reflections reflections;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            reflections = this.collect(inputStream);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ReflectionsException("could not obtain input stream from file " + file, e);
            }
            catch (Throwable throwable) {
                Utils.close(inputStream);
                throw throwable;
            }
        }
        Utils.close(inputStream);
        return reflections;
    }

    public Reflections merge(Reflections reflections) {
        if (reflections.store != null) {
            for (String indexName : reflections.store.keySet()) {
                Multimap<String, String> index = reflections.store.get(indexName);
                for (String key : index.keySet()) {
                    for (String string : index.get(key)) {
                        this.store.getOrCreate(indexName).put(key, string);
                    }
                }
            }
        }
        return this;
    }

    public void expandSuperTypes() {
        if (this.store.keySet().contains(Utils.index(SubTypesScanner.class))) {
            Multimap<String, String> mmap = this.store.get(Utils.index(SubTypesScanner.class));
            Sets.SetView<String> keys = Sets.difference(mmap.keySet(), Sets.newHashSet(mmap.values()));
            HashMultimap<String, String> expand = HashMultimap.create();
            for (String key : keys) {
                Class<?> type = ReflectionUtils.forName(key, this.loaders());
                if (type == null) continue;
                this.expandSupertypes(expand, key, type);
            }
            mmap.putAll(expand);
        }
    }

    private void expandSupertypes(Multimap<String, String> mmap, String key, Class<?> type) {
        for (Class<?> supertype : ReflectionUtils.getSuperTypes(type)) {
            if (!mmap.put(supertype.getName(), key)) continue;
            if (log != null) {
                log.debug("expanded subtype {} -> {}", (Object)supertype.getName(), (Object)key);
            }
            this.expandSupertypes(mmap, supertype.getName(), supertype);
        }
    }

    public <T> Set<Class<? extends T>> getSubTypesOf(Class<T> type) {
        String index = Utils.index(SubTypesScanner.class);
        List<String> typeNames = Arrays.asList(type.getName());
        Iterable<String> all = this.store.getAll(index, typeNames);
        ClassLoader[] loaders = this.loaders();
        List classes = ReflectionUtils.forNames(all, loaders);
        return Sets.newHashSet(classes);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Class<? extends Annotation> annotation, boolean honorInherited) {
        Iterable<String> annotated = this.store.get(Utils.index(TypeAnnotationsScanner.class), annotation.getName());
        Iterable<String> classes = this.getAllAnnotated(annotated, annotation.isAnnotationPresent(Inherited.class), honorInherited);
        return Sets.newHashSet(Iterables.concat(ReflectionUtils.forNames(annotated, this.loaders()), ReflectionUtils.forNames(classes, this.loaders())));
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation) {
        return this.getTypesAnnotatedWith(annotation, false);
    }

    public Set<Class<?>> getTypesAnnotatedWith(Annotation annotation, boolean honorInherited) {
        Iterable<String> annotated = this.store.get(Utils.index(TypeAnnotationsScanner.class), annotation.annotationType().getName());
        Iterable<Class<?>> filter = Iterables.filter(ReflectionUtils.forNames(annotated, this.loaders()), ReflectionUtils.withAnnotation(annotation));
        Iterable<String> classes = this.getAllAnnotated(Utils.names(filter), annotation.annotationType().isAnnotationPresent(Inherited.class), honorInherited);
        return Sets.newHashSet(Iterables.concat(filter, ReflectionUtils.forNames(Iterables.filter(classes, Predicates.not(Predicates.in(Sets.newHashSet(annotated)))), this.loaders())));
    }

    protected Iterable<String> getAllAnnotated(Iterable<String> annotated, boolean inherited, boolean honorInherited) {
        if (honorInherited) {
            if (inherited) {
                Iterable<String> subTypes = this.store.get(Utils.index(SubTypesScanner.class), Iterables.filter(annotated, new Predicate<String>(){

                    @Override
                    public boolean test(@Nullable String input) {
                        Class<?> type = ReflectionUtils.forName(input, Reflections.this.loaders());
                        return type != null && !type.isInterface();
                    }
                }));
                return Iterables.concat(subTypes, this.store.getAll(Utils.index(SubTypesScanner.class), subTypes));
            }
            return annotated;
        }
        Iterable<String> subTypes = Iterables.concat(annotated, this.store.getAll(Utils.index(TypeAnnotationsScanner.class), annotated));
        return Iterables.concat(subTypes, this.store.getAll(Utils.index(SubTypesScanner.class), subTypes));
    }

    public Set<Method> getMethodsAnnotatedWith(Class<? extends Annotation> annotation) {
        Iterable<String> methods = this.store.get(Utils.index(MethodAnnotationsScanner.class), annotation.getName());
        return Utils.getMethodsFromDescriptors(methods, this.loaders());
    }

    public Set<Method> getMethodsAnnotatedWith(Annotation annotation) {
        Set<Method> methods = this.getMethodsAnnotatedWith(annotation.annotationType());
        Predicate predicate = ReflectionUtils.withAnnotation(annotation);
        Set<Method> answer = ReflectionUtils.filter(methods, predicate);
        return answer;
    }

    public Set<Method> getMethodsMatchParams(Class<?> ... types) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(types).toString()), this.loaders());
    }

    public Set<Method> getMethodsReturn(Class returnType) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(returnType)), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getMethodsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), annotation.getName()), this.loaders());
    }

    public Set<Method> getMethodsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.filter(this.getMethodsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Class<? extends Annotation> annotation) {
        Iterable<String> methods = this.store.get(Utils.index(MethodAnnotationsScanner.class), annotation.getName());
        return Utils.getConstructorsFromDescriptors(methods, this.loaders());
    }

    public Set<Constructor> getConstructorsAnnotatedWith(Annotation annotation) {
        Set<Constructor> constructors = this.getConstructorsAnnotatedWith(annotation.annotationType());
        Predicate predicate = ReflectionUtils.withAnnotation(annotation);
        Set<Constructor> answer = ReflectionUtils.filter(constructors, predicate);
        return answer;
    }

    public Set<Constructor> getConstructorsMatchParams(Class<?> ... types) {
        return Utils.getConstructorsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), Utils.names(types).toString()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Class<? extends Annotation> annotation) {
        return Utils.getConstructorsFromDescriptors(this.store.get(Utils.index(MethodParameterScanner.class), annotation.getName()), this.loaders());
    }

    public Set<Constructor> getConstructorsWithAnyParamAnnotated(Annotation annotation) {
        return ReflectionUtils.filter(this.getConstructorsWithAnyParamAnnotated(annotation.annotationType()), ReflectionUtils.withAnyParameterAnnotation(annotation));
    }

    public Set<Field> getFieldsAnnotatedWith(Class<? extends Annotation> annotation) {
        Set<Field> result = Sets.newHashSet(new Field[0]);
        for (String annotated : this.store.get(Utils.index(FieldAnnotationsScanner.class), annotation.getName())) {
            result.add(Utils.getFieldFromString(annotated, this.loaders()));
        }
        return result;
    }

    public Set<Field> getFieldsAnnotatedWith(Annotation annotation) {
        Set<Field> fields = this.getFieldsAnnotatedWith(annotation.annotationType());
        Predicate predicate = ReflectionUtils.withAnnotation(annotation);
        return ReflectionUtils.filter(fields, predicate);
    }

    public Set<String> getResources(Predicate<String> namePredicate) {
        Iterable<String> resources = Iterables.filter(this.store.get(Utils.index(ResourcesScanner.class)).keySet(), namePredicate);
        return Sets.newHashSet(this.store.get(Utils.index(ResourcesScanner.class), resources));
    }

    public Set<String> getResources(final Pattern pattern) {
        return this.getResources(new Predicate<String>(){

            @Override
            public boolean test(String input) {
                return pattern.matcher(input).matches();
            }
        });
    }

    public List<String> getMethodParamNames(Method method) {
        Iterable<String> names = this.store.get(Utils.index(MethodParameterNamesScanner.class), Utils.name(method));
        return !Iterables.isEmpty(names) ? Arrays.asList(Iterables.getOnlyElement(names).split(", ")) : Arrays.asList(new String[0]);
    }

    public List<String> getConstructorParamNames(Constructor constructor) {
        Iterable<String> names = this.store.get(Utils.index(MethodParameterNamesScanner.class), Utils.name(constructor));
        return !Iterables.isEmpty(names) ? Arrays.asList(Iterables.getOnlyElement(names).split(", ")) : Arrays.asList(new String[0]);
    }

    public Set<Member> getFieldUsage(Field field) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(field)), new ClassLoader[0]);
    }

    public Set<Member> getMethodUsage(Method method) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(method)), new ClassLoader[0]);
    }

    public Set<Member> getConstructorUsage(Constructor constructor) {
        return Utils.getMembersFromDescriptors(this.store.get(Utils.index(MemberUsageScanner.class), Utils.name(constructor)), new ClassLoader[0]);
    }

    public Set<String> getAllTypes() {
        Set<String> allTypes = Sets.newHashSet(this.store.getAll(Utils.index(SubTypesScanner.class), Object.class.getName()));
        if (allTypes.isEmpty()) {
            throw new ReflectionsException("Couldn't find subtypes of Object. Make sure SubTypesScanner initialized to include Object class - new SubTypesScanner(false)");
        }
        return allTypes;
    }

    public Store getStore() {
        return this.store;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public File save(String filename) {
        return this.save(filename, this.configuration.getSerializer());
    }

    public File save(String filename, Serializer serializer) {
        File file = serializer.save(this, filename);
        if (log != null) {
            log.debug("Reflections successfully saved in " + file.getAbsolutePath() + " using " + serializer.getClass().getSimpleName());
        }
        return file;
    }

    private ClassLoader[] loaders() {
        return this.configuration.getClassLoaders();
    }
}

