/*
 * Decompiled with CFR 0.152.
 */
package com.tvd12.reflections.scanners;

import com.tvd12.reflections.Configuration;
import com.tvd12.reflections.ReflectionsException;
import com.tvd12.reflections.adapters.MetadataAdapter;
import com.tvd12.reflections.scanners.Scanner;
import com.tvd12.reflections.util.Multimap;
import com.tvd12.reflections.util.Predicates;
import com.tvd12.reflections.vfs.Vfs;
import java.util.function.Predicate;

public abstract class AbstractScanner
implements Scanner {
    private Configuration configuration;
    private Multimap<String, String> store;
    private Predicate<String> resultFilter = Predicates.alwaysTrue();

    @Override
    public boolean acceptsInput(String file) {
        return this.getMetadataAdapter().acceptsInput(file);
    }

    @Override
    public Object scan(Vfs.File file, Object classObject) {
        if (classObject == null) {
            try {
                classObject = this.configuration.getMetadataAdapter().getOrCreateClassObject(file);
            }
            catch (Exception e) {
                throw new ReflectionsException("could not create class object from file " + file.getRelativePath(), e);
            }
        }
        this.scan(classObject);
        return classObject;
    }

    public abstract void scan(Object var1);

    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public Multimap<String, String> getStore() {
        return this.store;
    }

    @Override
    public void setStore(Multimap<String, String> store) {
        this.store = store;
    }

    public Predicate<String> getResultFilter() {
        return this.resultFilter;
    }

    public void setResultFilter(Predicate<String> resultFilter) {
        this.resultFilter = resultFilter;
    }

    @Override
    public Scanner filterResultsBy(Predicate<String> filter) {
        this.setResultFilter(filter);
        return this;
    }

    @Override
    public boolean acceptResult(String fqn) {
        return fqn != null && this.resultFilter.test(fqn);
    }

    protected MetadataAdapter getMetadataAdapter() {
        return this.configuration.getMetadataAdapter();
    }

    public boolean equals(Object o) {
        return this == o || o != null && this.getClass() == o.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

